/***************************************
*                                      *
*   frmRDPOpen Create & Events         *
*                                      *
***************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>

#include <gdk/gdkkeysyms.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>

#include "rdpfile.h"
#include "connect.h"
#include "support.h"
#include "rdpopen.h"
#include "main.h"


/***************************************
*                                      *
*   frmRDPOpen Create                  *
*                                      *
***************************************/

GtkWidget*
create_frmRDPOpen (void)
{
  GtkWidget *frmRDPOpen;
  GtkWidget *btnOk;
  GtkWidget *btnCancel;

  frmRDPOpen = gtk_file_selection_new ("Select File");
  gtk_widget_set_name (frmRDPOpen, "frmRDPOpen");
  gtk_container_set_border_width (GTK_CONTAINER (frmRDPOpen), 10);
  gtk_window_set_position (GTK_WINDOW (frmRDPOpen), GTK_WIN_POS_CENTER);
  gtk_window_set_modal (GTK_WINDOW (frmRDPOpen), TRUE);
  gtk_window_set_destroy_with_parent (GTK_WINDOW (frmRDPOpen), TRUE);
  //gtk_window_set_icon (GTK_WINDOW (frmRDPOpen), 
  //                     gdk_pixbuf_new_from_xpm_data ((const char**) xpm_tsclient));
  gtk_window_set_icon (GTK_WINDOW (frmRDPOpen), create_pixbuf ("tsclient.png"));

  btnOk = GTK_FILE_SELECTION (frmRDPOpen)->ok_button;
  gtk_widget_set_name (btnOk, "btnOk");
  gtk_widget_show (btnOk);
  GTK_WIDGET_SET_FLAGS (btnOk, GTK_CAN_DEFAULT);

  btnCancel = GTK_FILE_SELECTION (frmRDPOpen)->cancel_button;
  gtk_widget_set_name (btnCancel, "btnCancel");
  gtk_widget_show (btnCancel);
  GTK_WIDGET_SET_FLAGS (btnCancel, GTK_CAN_DEFAULT);

  gtk_signal_connect (GTK_OBJECT (btnOk), "clicked",
                      GTK_SIGNAL_FUNC (on_btnOk_Open_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (btnCancel), "clicked",
                      GTK_SIGNAL_FUNC (on_btnCancel_Open_clicked),
                      NULL);

  gtk_widget_grab_default (btnOk);

  /* Store pointers to all widgets, for use by lookup_widget(). */
  GLADE_HOOKUP_OBJECT_NO_REF (frmRDPOpen, frmRDPOpen, "frmRDPOpen");
  GLADE_HOOKUP_OBJECT_NO_REF (frmRDPOpen, btnOk, "btnOk");
  GLADE_HOOKUP_OBJECT_NO_REF (frmRDPOpen, btnCancel, "btnCancel");

  return frmRDPOpen;
}


/***************************************
*                                      *
*   frmRDPOpen Events                  *
*                                      *
***************************************/

void
on_btnOk_Open_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *main_window;
  GtkWidget *this_window;
  gchar *file_name;

  main_window = gConnect;
  this_window = lookup_widget (GTK_WIDGET (button), "frmRDPOpen");
  gtk_widget_hide (this_window);
  // get path to file
  file_name = (gchar *) gtk_file_selection_get_filename (GTK_FILE_SELECTION (this_window));
  // check for file in ~/
  if (g_file_test (file_name, G_FILE_TEST_EXISTS)) {
    // load if exists
    rdp_file_init (g_rdp_file);
    rdp_file_load (g_rdp_file, file_name);
    rdp_file_set_screen (g_rdp_file, main_window);
  }
  gtk_widget_destroy (this_window);
}


void
on_btnCancel_Open_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *frmRDPOpen;
  frmRDPOpen = lookup_widget (GTK_WIDGET (button), "frmRDPOpen");
  gtk_widget_hide (frmRDPOpen);
  gtk_widget_destroy (frmRDPOpen);
}

