/*
 * DO NOT EDIT THIS FILE - it is generated by Glade.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h> 

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <glib.h>

#include <sys/types.h> 
#include <sys/stat.h> 
#include <dirent.h> 
#include <fcntl.h> 

#include "rdpfile.h"
#include "support.h"
#include "mrulist.h"

GtkWidget* lookup_widget (GtkWidget *widget, const gchar *widget_name) {
  GtkWidget *parent, *found_widget;

  for (;;)
    {
      if (GTK_IS_MENU (widget))
        parent = gtk_menu_get_attach_widget (GTK_MENU (widget));
      else
        parent = widget->parent;
      if (!parent)
        parent = gtk_object_get_data (GTK_OBJECT (widget), "GladeParentKey");
      if (parent == NULL)
        break;
      widget = parent;
    }

  found_widget = (GtkWidget*) gtk_object_get_data (GTK_OBJECT (widget),
                                                   widget_name);
  if (!found_widget)
    g_warning ("Widget not found: %s", widget_name);
  return found_widget;
}


static GList *pixmaps_directories = NULL;

/* Use this function to set the directory containing installed pixmaps. */
void add_pixmap_directory (const gchar *directory) {
  pixmaps_directories = g_list_prepend (pixmaps_directories,
                                        g_strdup (directory));
}


/* This is an internally used function to find pixmap files. */
gchar* find_pixmap_file (const gchar *filename) {
  GList *elem;

  /* We step through each of the pixmaps directory to find it. */
  elem = pixmaps_directories;
  while (elem)
    {
      gchar *pathname = g_strdup_printf ("%s%s%s", (gchar*)elem->data,
                                         G_DIR_SEPARATOR_S, filename);
      if (g_file_test (pathname, G_FILE_TEST_EXISTS))
        return pathname;
      g_free (pathname);
      elem = elem->next;
    }
  return NULL;
}


/* This is an internally used function to create pixmaps. */
GtkWidget* create_pixmap (GtkWidget *widget, const gchar *filename) {
  gchar *pathname = NULL;
  GtkWidget *pixmap;

  if (!filename || !filename[0])
      return gtk_image_new ();

  pathname = find_pixmap_file (filename);

  if (!pathname)
    {
      g_warning ("Couldn't find pixmap file: %s", filename);
      return gtk_image_new ();
    }

  pixmap = gtk_image_new_from_file (pathname);
  g_free (pathname);
  return pixmap;
}


/* This is an internally used function to create pixmaps. */
GdkPixbuf* create_pixbuf (const gchar *filename) {
  gchar *pathname = NULL;
  GdkPixbuf *pixbuf;
  GError *error = NULL;

  if (!filename || !filename[0])
      return NULL;

  pathname = find_pixmap_file (filename);

  if (!pathname)
    {
      g_warning ("Couldn't find pixmap file: %s", filename);
      return NULL;
    }

  pixbuf = gdk_pixbuf_new_from_file (pathname, &error);
  if (!pixbuf)
    {
      fprintf (stderr, "Failed to load pixbuf file: %s: %s\n",
               pathname, error->message);
      g_error_free (error);
    }
  g_free (pathname);
  return pixbuf;
}


/***************************************
*                                      *
*   tsc_check_files                    *
*                                      *
***************************************/
 
int tsc_check_files ()
{
  DIR *dptr;
  gchar *path_name;
  gchar *file_name;

  // create .tsclient dir in ~/
  path_name = g_build_path ((const gchar *)"/", g_get_home_dir(), ".tsclient", NULL);
  dptr = opendir(path_name);
  if (dptr == NULL) mkdir(path_name, 0700);

  // create mru.tsc dir in ~/.tsclient/
  file_name = g_build_path ((const gchar *)"/", g_get_home_dir(), ".tsclient", "mru.tsc", NULL);
  /* touch the file */
  if (!g_file_test (file_name, G_FILE_TEST_EXISTS)) {
    open(file_name, O_WRONLY | O_CREAT | O_TRUNC, 0600);
  }

  // create last.tsc dir in ~/.tsclient/
  file_name = g_build_path ((const gchar *)"/", g_get_home_dir(), ".tsclient", "last.tsc", NULL);
  /* touch the file */
  if (!g_file_test (file_name, G_FILE_TEST_EXISTS)) {
    open(file_name, O_WRONLY | O_CREAT | O_TRUNC, 0600);
  }
 
  /* complete successfully */
  return 0;

  
}


/***************************************
*   tsc_set_window_mode                *
*   window_mode                        *
*     0 == compact                     *
*     1 == complex                     *
***************************************/

void tsc_set_window_mode (GtkWidget *main_window, int *window_mode)
{
  GtkWidget *vbxMain, *vbxComplete, *vbxCompact;
  GtkWidget *btnConnect0, *btnConnect1;
  GtkWidget *txtComputer0, *txtComputer1;
  GtkWidget *hbbAppOps0, *hbbAppOps1;
  gint x = 0;
  gint y = 0;
  guint pos = 0;

  vbxMain = lookup_widget(main_window, "vbxMain");
  vbxComplete = lookup_widget(main_window, "vbxComplete");
  vbxCompact = lookup_widget(main_window, "vbxCompact");
  hbbAppOps0 = lookup_widget(main_window, "hbbAppOps0");
  hbbAppOps1 = lookup_widget(main_window, "hbbAppOps1");
  btnConnect0 = lookup_widget(main_window, "btnConnect0");
  btnConnect1 = lookup_widget(main_window, "btnConnect1");
  txtComputer0 = lookup_widget(main_window, "txtComputer0");
  txtComputer1 = lookup_widget(main_window, "txtComputer1");

  gtk_window_get_position (GTK_WINDOW (main_window), &x, &y);

  if (window_mode == (int*)WM_COMPACT) {
    gtk_editable_delete_text ((GtkEditable*) txtComputer1, 0, -1);
    gtk_editable_insert_text((GtkEditable*) txtComputer1, 
                              gtk_editable_get_chars ((GtkEditable*) txtComputer0, 0, -1), 
                              strlen(gtk_editable_get_chars ((GtkEditable*) txtComputer0, 0, -1)), 
                              &pos);
    gtk_widget_show(vbxCompact);
    gtk_widget_hide(vbxComplete);
    gtk_widget_show(hbbAppOps1);
    gtk_widget_hide(hbbAppOps0);
    gtk_widget_grab_default (btnConnect1);
    gtk_entry_set_activates_default (GTK_ENTRY (txtComputer1), TRUE);
    gtk_widget_grab_focus (txtComputer1);
  } else {
    if (y > 192) {
      y = y - 192;
    } else {
      y = 36;
    }
    gtk_window_move (GTK_WINDOW (main_window), x, y);
    gtk_editable_delete_text ((GtkEditable*) txtComputer0, 0, -1);
    gtk_editable_insert_text((GtkEditable*) txtComputer0, 
                              gtk_editable_get_chars ((GtkEditable*) txtComputer1, 0, -1), 
                              strlen(gtk_editable_get_chars ((GtkEditable*) txtComputer1, 0, -1)), 
                              &pos);
    gtk_widget_show(vbxComplete);
    gtk_widget_hide(vbxCompact);
    gtk_widget_show(hbbAppOps0);
    gtk_widget_hide(hbbAppOps1);
    gtk_widget_grab_default (btnConnect0);
    gtk_entry_set_activates_default (GTK_ENTRY (txtComputer0), TRUE);
    gtk_widget_grab_focus (txtComputer0);
  }
}



int tsc_launch_rdesktop (rdp_file *rdp_in, int window_mode)
{
  rdp_file *rdp;
  char *c_argv[MAX_ARGVS];
  char buffer[MAX_ARGV_LEN];
  int c_argc = 0;
  GError *err = NULL;
  int cnt = 0;
  int is_vnc = 0;
  gchar *std_out;
  gchar *std_err;
  gint exit_stat;

  rdp = rdp_in;
  
  if (strlen(rdp->full_address)) {

    if (rdp->full_address[strlen(rdp->full_address) - 4] == ':'
        && rdp->full_address[strlen(rdp->full_address) - 3] == 'v'
        && rdp->full_address[strlen(rdp->full_address) - 2] == 'n'
        && rdp->full_address[strlen(rdp->full_address) - 1] == 'c') {
      is_vnc = 1;
    }

    mru_add_server (rdp->full_address);

    if (is_vnc == 0 ) {
      sprintf(buffer, "rdesktop");
      c_argv[c_argc++] = strdup(buffer);

      if (window_mode == 0) {
        // full window mode - use all opts    
        if (strlen(rdp->username)) {
          sprintf(buffer, "-u%s", (char*)g_strescape(rdp->username, NULL));
          c_argv[c_argc++] = strdup(buffer);
        }
        if (strlen(rdp->password)) {
          sprintf(buffer, "-p%s", (char*)g_strescape(rdp->password, NULL));
          c_argv[c_argc++] = strdup(buffer);
        }
        if (strlen(rdp->domain)) {
          sprintf(buffer, "-d%s", (char*)g_strescape(rdp->domain, NULL));
          c_argv[c_argc++] = strdup(buffer);
        }

        if (rdp->screen_mode_id == 2) {
          if (rdp->alternate_full_switch == 1) {
            sprintf(buffer, "-F");
          } else {
            sprintf(buffer, "-f");
          }
          c_argv[c_argc++] = strdup(buffer);
        } else {
          switch (rdp->desktopwidth) {
          case 640:
            sprintf(buffer, "-g640x480");
            c_argv[c_argc++] = strdup(buffer);
            break;
          case 800:
            sprintf(buffer, "-g800x600");
            c_argv[c_argc++] = strdup(buffer);
            break;
          case 1024:
            sprintf(buffer, "-g1024x768");
            c_argv[c_argc++] = strdup(buffer);
            break;
          case 1152:
            sprintf(buffer, "-g1152x864");
            c_argv[c_argc++] = strdup(buffer);
            break;
          case 1280:
            sprintf(buffer, "-g1280x960");
            c_argv[c_argc++] = strdup(buffer);
            break;
          default:
            break;
          }
        }
      
	      /*
        switch (rdp->session_bpp) {
        case 8:
          sprintf(buffer, "-D8");
          c_argv[c_argc++] = strdup(buffer);
          break;
        case 15:
          sprintf(buffer, "-D15");
          c_argv[c_argc++] = strdup(buffer);
          break;
        case 16:
          sprintf(buffer, "-D16");
          c_argv[c_argc++] = strdup(buffer);
          break;
        case 24:
          sprintf(buffer, "-D24");
          c_argv[c_argc++] = strdup(buffer);
          break;
        default:
          break;
        }
    	  */
      
        if (rdp->bitmapcachepersistenable == 1) {
          sprintf(buffer, "-b");
          c_argv[c_argc++] = strdup(buffer);
        }
        // Extra
        if (rdp->no_motion_events == 1) {
          sprintf(buffer, "-m");
          c_argv[c_argc++] = strdup(buffer);
        }

        if (rdp->enable_wm_keys == 1) {
          sprintf(buffer, "-K");
          c_argv[c_argc++] = strdup(buffer);
        }

        if ( rdp->keyboard_language && strlen (rdp->keyboard_language) ) {
          sprintf ( buffer, "-k");
          c_argv[c_argc++] = strdup(buffer);
          c_argv[c_argc++] = strdup(rdp->keyboard_language);
        }

        if (rdp->enable_alternate_shell == 1) {
          if ( rdp->alternate_shell && strlen (rdp->alternate_shell) && rdp->shell_working_directory && strlen (rdp->shell_working_directory) ) {
            sprintf ( buffer, "-s");
            c_argv[c_argc++] = strdup(buffer);
            c_argv[c_argc++] = strdup(rdp->alternate_shell);
          }

          if ( rdp->shell_working_directory && strlen (rdp->shell_working_directory) ) {
            sprintf ( buffer, "-c");
            c_argv[c_argc++] = strdup(buffer);
            c_argv[c_argc++] = strdup(rdp->shell_working_directory);
          }
        }
        // end of complete mode shit
      }

      // do this shit for all modes
      sprintf(buffer, "%s", (char*)g_strescape(rdp->full_address, NULL));
      c_argv[c_argc++] = strdup(buffer);

    } else {

      // it's a vncviewer call

      sprintf(buffer, "vncviewer");
      c_argv[c_argc++] = strdup(buffer);

      if (rdp->screen_mode_id == 2) {
        sprintf(buffer, "-f");
        c_argv[c_argc++] = strdup(buffer);
      } else {
        switch (rdp->desktopwidth) {
        case 640:
          sprintf(buffer, "-g");
          c_argv[c_argc++] = strdup(buffer);
          sprintf(buffer, "640x480");
          c_argv[c_argc++] = strdup(buffer);
          break;
        case 800:
          sprintf(buffer, "-g");
          c_argv[c_argc++] = strdup(buffer);
          sprintf(buffer, "800x600");
          c_argv[c_argc++] = strdup(buffer);
          break;
        case 1024:
          sprintf(buffer, "-g");
          c_argv[c_argc++] = strdup(buffer);
          sprintf(buffer, "1024x768");
          c_argv[c_argc++] = strdup(buffer);
          break;
        case 1152:
          sprintf(buffer, "-g");
          c_argv[c_argc++] = strdup(buffer);
          sprintf(buffer, "1152x864");
          c_argv[c_argc++] = strdup(buffer);
          break;
        case 1280:
          sprintf(buffer, "-g");
          c_argv[c_argc++] = strdup(buffer);
          sprintf(buffer, "1280x960");
          c_argv[c_argc++] = strdup(buffer);
          break;
        default:
          break;
        }
      }

      switch (rdp->session_bpp) {
      case 8:
        sprintf(buffer, "-d");
        c_argv[c_argc++] = strdup(buffer);
        sprintf(buffer, "8");
        c_argv[c_argc++] = strdup(buffer);
        break;
      case 15:
        sprintf(buffer, "-d");
        c_argv[c_argc++] = strdup(buffer);
        sprintf(buffer, "15");
        c_argv[c_argc++] = strdup(buffer);
        break;
      case 16:
        sprintf(buffer, "-d");
        c_argv[c_argc++] = strdup(buffer);
        sprintf(buffer, "16");
        c_argv[c_argc++] = strdup(buffer);
        break;
      case 24:
        sprintf(buffer, "-d");
        c_argv[c_argc++] = strdup(buffer);
        sprintf(buffer, "24");
        c_argv[c_argc++] = strdup(buffer);
        break;
      default:
        break;
      }

      if (rdp->no_motion_events == 1) {
        sprintf(buffer, "-v");
        c_argv[c_argc++] = strdup(buffer);
      }

      // do this shit for all modes
      sprintf(buffer, "%s", (char*)g_strescape(rdp->full_address, NULL));
      buffer[strlen(buffer)-4] = '\0';
      c_argv[c_argc++] = strdup(buffer);

    }

    c_argv[c_argc++] = NULL;

    //if (!g_spawn_async (NULL, (gchar**)c_argv, NULL, G_SPAWN_SEARCH_PATH,
    //      NULL, NULL, NULL, &err))

    // complete events in gtk queue
    while(gtk_events_pending())
      gtk_main_iteration();

    if (!g_spawn_sync (NULL, (gchar**)c_argv, NULL, G_SPAWN_SEARCH_PATH,
          NULL, NULL, &std_out, &std_err, &exit_stat, &err))
      printf ("failed: spawn_async\n");
    if (err)
      printf ("message %s\n", err->message);
    if (std_err && strlen(std_err))
      printf ("\n%s\n", std_err);
    
    for (cnt = 0; cnt < c_argc; cnt++) {
      //printf ("arg %d:  %s\n", cnt, c_argv[cnt]);
      free(c_argv[cnt]);
    }

  } else {
    return 1;  
  }

  return 0;

}

