/***************************************
*                                      *
*   MRU File Handlers                  *
*                                      *
***************************************/


#include <glib.h>
#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h> 
#include <sys/stat.h> 
#include <dirent.h> 

#include "mrulist.h"
#include "rdpfile.h"
#include "support.h"


/***************************************
*                                      *
*   mru_file_to_list                   *
*                                      *
***************************************/

int mru_file_to_list (GSList** list)
{
  gchar *mymrufile;
  FILE* fptr;
  gchar buffer[MAX_SERVER_SIZE];
  gchar *name = NULL;
  int i;

  tsc_check_files();

  // create .tsclient dir in ~/
  mymrufile = g_build_path ((const gchar *)"/", g_get_home_dir(), ".tsclient", "mru.tsc", NULL);

  /* open the file for reading */
  if((fptr = fopen(mymrufile, "r")) == NULL)
  {
    return 1;   /* bad fully qualified path to file */
  }

  /* Grab the first line, it may indicate a unicode file */
  buffer[0] = '\0';
  if(fgets(buffer, MAX_SERVER_SIZE, fptr) == NULL)
  {
    /* complete successfully */
    return 0;
  }

  i = 0;
  /* remember the first line is already in the buffer */
  do
  {
    if(buffer[strlen(buffer) - 1] == '\n') buffer[strlen(buffer) - 1] = '\0';
    if(buffer[strlen(buffer) - 1] == '\r') buffer[strlen(buffer) - 1] = '\0';
    buffer[MAX_SERVER_SIZE - 1] = '\0';
    name = g_strdup(buffer);
    /* append next structure to the list */
    *list = g_slist_append(*list, name);
    
    /* read the next flat file record */
    buffer[0] = '\n';
    i++;
  }
  while((fgets(buffer, MAX_SERVER_SIZE, fptr) != NULL && i <= 10));

  /* close file */
  fclose(fptr);

  /* complete successfully */
  return 0;
}


/***************************************
*                                      *
*   mru_list_to_file                   *
*                                      *
***************************************/
 
int mru_list_to_file (GSList** list)
{
  GSList* dptr = NULL;
  gchar *mymrufile;
  FILE* fptr;
  char buffer[MAX_SERVER_SIZE * 10];
  int i;
  
  tsc_check_files();

  // create mru.tsc dir in ~/.tsclient/
  mymrufile = g_build_path ((const gchar *)"/", g_get_home_dir(), ".tsclient", "mru.tsc", NULL);

  /* open the file for writing*/
  if((fptr = fopen(mymrufile, "wt")) == NULL)
  {
    return 1;   /* bad fully qualified path to file */
  }

  /* write each record to the flat file in turn */
  buffer[0] = '\0';
  dptr = *list;
  i = 0;
  while((dptr != NULL && i <= 10))
  {
    /* combine the key, type, and value segments */
    strncat(buffer, (char*)dptr->data, MAX_SERVER_SIZE - 2);
    strcat(buffer, "\r");
    strcat(buffer, "\n");

    /* move forward */
    dptr = dptr->next;
    i++;
  }
  //strncat(buffer, '\0', 1);
  
  /* save flat file */
  if(fputs(buffer, fptr) == EOF)
  {
      return 2;   /* write failed */
  }

  /* close file */
  fclose(fptr);
 
  /* complete successfully */
  return 0;

  
}


/***************************************
*                                      *
*   mru_add_server                     *
*                                      *
***************************************/
 
int mru_add_server(char *server_name)
{
  GSList* list = NULL;
  GSList* list_new = NULL;

  mru_file_to_list (&list);

  while (list) {
    if (strcmp(server_name, (char*)list->data) != 0) {
      list_new = g_slist_append (list_new, g_strdup((char*)list->data));
    }
    g_free (list->data);
    list = list->next;
  }
  g_slist_free (list);
  
  list_new = g_slist_prepend (list_new, g_strdup(server_name));

  mru_list_to_file (&list_new);

  while (list_new) {
    g_free (list_new->data);
    list_new = list_new->next;
  }
  g_slist_free (list_new);

  /* complete successfully */
  return 0;
}


/***************************************
*                                      *
*   mru_list_to_screen                 *
*                                      *
***************************************/
 
int mru_to_screen (GtkWidget *main_window)
{
  GList *server_items = NULL;
  GSList *server_list = NULL;
  GtkWidget *widget;
  gchar *name = NULL;
  int i;

  // Get the mru.tsc
  mru_file_to_list (&server_list);

  // load mru combos
  i = 0;
  while ((server_list != NULL && i <= 10))
  {
    name = server_list->data;
    server_items = g_list_append (server_items, (gpointer)name);
    server_list = server_list->next;
    i++;
  }
  widget = lookup_widget (main_window, "cboComputer0");
  gtk_combo_set_popdown_strings (GTK_COMBO (widget), server_items);
  widget = lookup_widget (main_window, "cboComputer1");
  gtk_combo_set_popdown_strings (GTK_COMBO (widget), server_items);
  g_list_free (server_items);

  return 0;
}

