/*
 * vdrive-dir.h - Virtual disk-drive implementation.
 *                Directory specific functions.
 *
 * Written by
 *  Andreas Boose <viceteam@t-online.de>
 *
 * This file is part of VICE, the Versatile Commodore Emulator.
 * See README for copyright notice.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307  USA.
 *
 */

#ifndef _VDRIVE_DIR_H
#define _VDRIVE_DIR_H

#include "types.h"

#define SLOT_TYPE_OFFSET      2
#define SLOT_FIRST_TRACK      3
#define SLOT_FIRST_SECTOR     4
#define SLOT_NAME_OFFSET      5
#define SLOT_SIDE_TRACK       21
#define SLOT_SIDE_SECTOR      22
#define SLOT_NR_BLOCKS        30

struct vdrive_s;
struct bufferinfo_s;

extern void vdrive_dir_init(void);
extern int vdrive_dir_create_directory(struct vdrive_s *vdrive,
                                       const char *name,
                                       int length, int filetype,
                                       BYTE *outputptr);
extern void vdrive_dir_find_first_slot(struct vdrive_s *vdrive,
                                       const char *name,
                                       int length, unsigned int type);
extern BYTE *vdrive_dir_find_next_slot(struct vdrive_s *vdrive);
extern void vdrive_dir_no_a0_pads(BYTE *ptr, int l);
extern void vdrive_dir_remove_slot(struct vdrive_s *vdrive, BYTE *slot);
extern void vdrive_dir_create_slot(struct bufferinfo_s *p, char *realname,
                                   int reallength, int filetype);

#endif

