#!/usr/bin/perl
# OggEnc

# This program is distributed under the GNU General Public License, version 2.
# A copy of this license is included with this source.
#
# Copyright  2001, Daniel Resare <noa@metamatrix.se>

# this script creates a headerfile with charset maps from charset mapping
# files in the format published on unicode.org.
# To add more encodings, simply pull the desired files from
# http://www.unicode.org/Public/ and add encoding name and file name to 
# %maps

%maps = ('ISO-8859-1' => '8859-1.map',
	'ISO-8859-2' => '8859-2.map');

print <<EOF;
/* This file was automatically generated by make_code_map.pl
   please don't edit directly
   Daniel Resare <noa\@metamatrix.se>
*/
EOF


print("charset_map maps[] = {");
for(keys(%maps)) {
  print("\n\t{\"" . $_ . "\",\n\t {");

  open FILE, $maps{$_} or die;
  $i = 0;
  while(<FILE>) {
    if(/^#/) {
      next;
    }
    if($i != 0) {
      print ",";
    }
    @fields = split;
    unless ($i % 8) {
      print "\n\t  ";
    }
    print "$fields[1]";
    $i++;
  }
  print("\n\t }\n\t},");
}
print "\n\t{NULL}\n};\n";

