/*
 * WBXML Lib, the WBXML Library.
 * Copyright (C) 2002-2003  Aymerick Jhanne
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License (version 2.1) as published by the Free Software Foundation.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * LGPL v2.1: http://www.gnu.org/licenses/lgpl.txt
 *
 * Author Contact: libwbxml@jehanne.org
 * WBXML Lib home: http://libwbxml.jehanne.org
 */
 
/**
 * @file xml2wbxml_clb.h
 * @ingroup xml2wbxml
 *
 * @author Aymerick Jhanne <libwbxml@jehanne.org>
 * @date 03/03/11
 *
 * @brief XML to WBXML Converter Callbacks
 */

#ifndef XML2WBXML_CLB_H
#define XML2WBXML_CLB_H

#include <expat.h>  /* XML Parser */

#include "wbxml_conv.h"


/** @addtogroup xml2wbxml 
 *  @{ 
 */

/** xml2wbxml Context Structure */
typedef struct xml2wbxmlCtx_s {
    WBXMLTree *tree;                    /**< The WBXML Tree we are constructing */
    WBXMLTreeNode *current;             /**< Current Tree Node */
    WBXMLError error;                   /**< Error while parsing Document ? */
} xml2wbxmlCtx;

/**
 * @brief Doctype Declaration Callback
 * @param ctx User data
 * @param doctypeName Doctype Name
 * @param sysid System ID
 * @param pubid Public ID
 * @param has_internal_subset Non-zero if the DOCTYPE declaration has an internal subset
 */
void xml2wbxml_clb_doctype_decl(void *ctx, const XML_Char *doctypeName, 
                                const XML_Char *sysid, const XML_Char *pubid, 
                                int has_internal_subset);

/**
 * @brief Start Element Callback
 * @param ctx User data
 * @param localName The local tag name
 * @param attrs The attributes attached to the element
 */
void xml2wbxml_clb_start_element(void *ctx, const XML_Char *localName, const XML_Char **attrs);

/**
 * @brief End Element Callback
 * @param ctx User data
 * @param localName The local tag name
 */
void xml2wbxml_clb_end_element(void *ctx, const XML_Char *localName);

/**
 * @brief Start of CDATA Section Callback
 * @param ctx User data
 */
void xml2wbxml_clb_start_cdata(void *ctx);

/**
 * @brief End of CDATA Section Callback
 * @param ctx User data
 */
void xml2wbxml_clb_end_cdata(void *ctx);

/**
 * @brief Characters Callback
 * @param ctx User data
 * @param ch The characters array
 * @param len The number of characters to read from the array
 */
void xml2wbxml_clb_characters(void *ctx, const XML_Char *ch, int len);

/**
 * @brief Processing Instruction Callback
 * @param ctx User data
 * @param target The processing instruction target.
 * @param data The processing instruction data, or null if  none was supplied. The data does
 *             not include any whitespace separating it from the target
 */
void xml2wbxml_clb_pi(void *ctx, const XML_Char *target, const XML_Char *data);

/** @} */

#endif
