/*
 * WBXML Lib, the WBXML Library.
 * Copyright (C) 2002-2003  Aymerick Jhanne
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License (version 2.1) as published by the Free Software Foundation.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * LGPL v2.1: http://www.gnu.org/licenses/lgpl.txt
 *
 * Author Contact: libwbxml@jehanne.org
 * WBXML Lib home: http://libwbxml.jehanne.org
 */
 
/**
 * @file wbxml2xml_clb.h
 * @ingroup wbxml2xml
 *
 * @author Aymerick Jhanne <libwbxml@jehanne.org>
 * @date 03/02/22
 *
 * @brief WBXML to XML Converter Callbacks
 */

#ifndef WBXML2XML_CLB_H
#define WBXML2XML_CLB_H

#include "wbxml_conv.h"


/** @addtogroup wbxml2xml 
 *  @{ 
 */

/** wbxml2xml Context Structure */
typedef struct wbxml2xmlCtx_s {
    WBXMLBuffer *xml;   /**< The XML we are producing */
    WB_ULONG indent;    /**< XML indent */
    WBXMLError error;   /**< Error in Callbacks ? */
    WB_BOOL set_indent; /**< Indent resulting XML ? */
    WB_BOOL content;    /**< Have we already outputed content inside current tag ? */
} wbxml2xmlCtx;

/**
 * @brief Start Document Callback
 * @param ctx User data
 * @param charset Charset (IANA code)
 * @param lang Language Table for this Document (cf: wbxml_table.[h|c])
 */
void wbxml2xml_clb_start_document(void *ctx, WB_LONG charset, const WBXMLLangEntry *lang);

/**
 * @brief End Document Callback
 * @param ctx User data
 */
void wbxml2xml_clb_end_document(void *ctx);

/**
 * @brief Start Element Callback
 * @param ctx User data
 * @param localName The local tag name
 * @param atts The attributes attached to the element
 * @param empty Set to TRUE if this is an empty element
 */
void wbxml2xml_clb_start_element(void *ctx, WBXMLTag *localName, WBXMLAttribute **atts, WB_BOOL empty);

/**
 * @brief End Element Callback
 * @param ctx User data
 * @param localName The local tag name
 * @param empty Set to TRUE if this is an empty element
 */
void wbxml2xml_clb_end_element(void *ctx, WBXMLTag *localName, WB_BOOL empty);

/**
 * @brief Characters Callback
 * @param ctx User data
 * @param ch The characters
 * @param start The start position in the array
 * @param length The number of characters to read from the array
 */
void wbxml2xml_clb_characters(void *ctx, WB_UTINY *ch, WB_ULONG start, WB_ULONG length);

/**
 * @brief Processing Instruction Callback
 * @param ctx User data
 * @param target The processing instruction target.
 * @param data The processing instruction data, or null if  none was supplied. The data does
 *            not include any whitespace separating it from the target
 */
void wbxml2xml_clb_pi(void *ctx, const WB_UTINY *target, WB_UTINY *data);

/** @} */

#endif
