dnl
dnl Check for minimum version of libtool
dnl AC_PREREQ_LIBTOOL([MINIMUM VERSION],[ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND ]])
AC_DEFUN([AC_PREREQ_LIBTOOL],
  [
    lt_min_full=ifelse([$1], ,1.3.5,$1)
    lt_min=`echo $lt_min_full | sed -e 's/\.//g'`
    AC_MSG_CHECKING(for libtool >= $lt_min_full)
    lpwd="`pwd`"
    lt_pathname="`echo $lpwd/ltmain.sh | sed -e 's/\=build\///g'`"
    lt_version="`grep '^VERSION' $lt_pathname | sed -e 's/\.//g;s/VERSION\=//g;s/[a-zA-Z]//g;s/-//g'`"

    if test $lt_version -lt 100; then
      lt_version=`expr $lt_version \* 10`
    fi

    if test $lt_version -lt $lt_min; then
      AC_MSG_RESULT(no)
      ifelse([$3], , :, [$3])
    fi
    AC_MSG_RESULT(yes)
    ifelse([$2], , :, [$2])
  ])

dnl
AC_DEFUN([AC_CHECK_LIRC],
  [AC_ARG_ENABLE(lirc,
     [  --disable-lirc          Turn off LIRC support.],
     , enable_lirc=yes)

  if test x"$enable_lirc" = xyes; then
     have_lirc=yes
     AC_REQUIRE_CPP
     AC_CHECK_LIB(lirc_client,lirc_init,
           AC_CHECK_HEADER(lirc/lirc_client.h, true, have_lirc=no), have_lirc=no)
     if test "$have_lirc" = "yes"; then

        if test x"$LIRC_PREFIX" != "x"; then
           lirc_libprefix="$LIRC_PREFIX/lib"
  	   LIRC_INCLUDE="-I$LIRC_PREFIX/include"
        fi
        for llirc in $lirc_libprefix /lib /usr/lib /usr/local/lib; do
          AC_CHECK_FILE("$llirc/liblirc_client.a",
             LIRC_LIBS="$llirc/liblirc_client.a"
             AC_DEFINE(HAVE_LIRC),,)
        done
     else
         AC_MSG_RESULT([*** LIRC client support not available, LIRC support will be disabled ***]);
     fi
  fi

     AC_SUBST(LIRC_LIBS)
     AC_SUBST(LIRC_INCLUDE)
])


dnl AC_C_ATTRIBUTE_ALIGNED
dnl define ATTRIBUTE_ALIGNED_MAX to the maximum alignment if this is supported
AC_DEFUN([AC_C_ATTRIBUTE_ALIGNED],
    [AC_CACHE_CHECK([__attribute__ ((aligned ())) support],
        [ac_cv_c_attribute_aligned],
        [ac_cv_c_attribute_aligned=0
        for ac_cv_c_attr_align_try in 2 4 8 16 32 64; do
            AC_TRY_COMPILE([],
                [static char c __attribute__ ((aligned($ac_cv_c_attr_align_try))) = 0
; return c;],
                [ac_cv_c_attribute_aligned=$ac_cv_c_attr_align_try])
        done])
    if test x"$ac_cv_c_attribute_aligned" != x"0"; then
        AC_DEFINE_UNQUOTED([ATTRIBUTE_ALIGNED_MAX],
            [$ac_cv_c_attribute_aligned],[maximum supported data alignment])
    fi])

dnl AC_TRY_CFLAGS (CFLAGS, [ACTION-IF-WORKS], [ACTION-IF-FAILS])
dnl check if $CC supports a given set of cflags
AC_DEFUN([AC_TRY_CFLAGS],
    [AC_MSG_CHECKING([if $CC supports $1 flags])
    SAVE_CFLAGS="$CFLAGS"
    CFLAGS="$1"
    AC_TRY_COMPILE([],[],[ac_cv_try_cflags_ok=yes],[ac_cv_try_cflags_ok=no])
    CFLAGS="$SAVE_CFLAGS"
    AC_MSG_RESULT([$ac_cv_try_cflags_ok])
    if test x"$ac_cv_try_cflags_ok" = x"yes"; then
        ifelse([$2],[],[:],[$2])
    else
        ifelse([$3],[],[:],[$3])
    fi])


dnl AC_CHECK_GENERATE_INTTYPES_H (INCLUDE-DIRECTORY)
dnl generate a default inttypes.h if the header file does not exist already
AC_DEFUN([AC_CHECK_GENERATE_INTTYPES],
    [AC_CHECK_HEADER([inttypes.h],[],
        [AC_COMPILE_CHECK_SIZEOF([char],[1])
        AC_COMPILE_CHECK_SIZEOF([short],[2])
        AC_COMPILE_CHECK_SIZEOF([int],[4])
        AC_COMPILE_CHECK_SIZEOF([long long],[8])
        cat >$1/inttypes.h << EOF
#ifndef _INTTYPES_H
#define _INTTYPES_H
/* default inttypes.h for people who do not have it on their system */
#if (!defined __int8_t_defined) && (!defined __BIT_TYPES_DEFINED__)
#define __int8_t_defined
typedef signed char int8_t;
typedef signed short int16_t;
typedef signed int int32_t;
#ifdef ARCH_X86
typedef signed long long int64_t;
#endif
#endif
#if (!defined _LINUX_TYPES_H)
typedef unsigned char uint8_t;
typedef unsigned short uint16_t;
typedef unsigned int uint32_t;
#ifdef ARCH_X86
typedef unsigned long long uint64_t;
#endif
#endif
#endif
EOF
        ])])


dnl AC_COMPILE_CHECK_SIZEOF (TYPE SUPPOSED-SIZE)
dnl abort if the given type does not have the supposed size
AC_DEFUN([AC_COMPILE_CHECK_SIZEOF],
    [AC_MSG_CHECKING(that size of $1 is $2)
    AC_TRY_COMPILE([],[switch (0) case 0: case (sizeof ($1) == $2):;],[],
        [AC_MSG_ERROR([can not build a default inttypes.h])])
    AC_MSG_RESULT([yes])])
dnl AM_PATH_ORBIT([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND [, MODULES]]]])
dnl Test for ORBit, and define ORBIT_CFLAGS and ORBIT_LIBS
dnl
AC_DEFUN(AM_PATH_ORBIT,
[dnl 
dnl Get the cflags and libraries from the orbit-config script
dnl
AC_ARG_WITH(orbit-prefix,[  --with-orbit-prefix=PFX   Prefix where ORBIT is installed (optional)],
            orbit_config_prefix="$withval", orbit_config_prefix="")
AC_ARG_WITH(orbit-exec-prefix,[  --with-orbit-exec-prefix=PFX Exec prefix where ORBIT is installed (optional)],
            orbit_config_exec_prefix="$withval", orbit_config_exec_prefix="")
AC_ARG_ENABLE(orbittest, [  --disable-orbittest       Do not try to compile and run a test ORBIT program],
		    , enable_orbittest=yes)

  for module in . $4
  do
      case "$module" in
         server) 
             orbit_config_args="$orbit_config_args server"
	 ;;
         client) 
             orbit_config_args="$orbit_config_args client"
         ;;
      esac
  done
  if test x$orbit_config_args = x ; then
	orbit_config_args=server
  fi

  if test x$orbit_config_exec_prefix != x ; then
     orbit_config_args="$orbit_config_args --exec-prefix=$orbit_config_exec_prefix"
     if test x${ORBIT_CONFIG+set} != xset ; then
        ORBIT_CONFIG=$orbit_config_exec_prefix/bin/orbit-config
     fi
  fi
  if test x$orbit_config_prefix != x ; then
     orbit_config_args="$orbit_config_args --prefix=$orbit_config_prefix"
     if test x${ORBIT_CONFIG+set} != xset ; then
        ORBIT_CONFIG=$orbit_config_prefix/bin/orbit-config
     fi
  fi

  AC_PATH_PROG(ORBIT_CONFIG, orbit-config, no)
  min_orbit_version=ifelse([$1], , 0.5.1, $1)
  AC_MSG_CHECKING(for ORBit - version >= $min_orbit_version)
  no_orbit=""
  if test "$ORBIT_CONFIG" = "no" ; then
    no_orbit=yes
  else
    ORBIT_CFLAGS=`$ORBIT_CONFIG $orbit_config_args --cflags`
    ORBIT_LIBS=`$ORBIT_CONFIG $orbit_config_args --libs`
    orbit_config_major_version=`$ORBIT_CONFIG $orbit_config_args --version | \
	   sed -e 's,[[^0-9.]],,g' -e 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
    orbit_config_minor_version=`$ORBIT_CONFIG $orbit_config_args --version | \
	   sed -e 's,[[^0-9.]],,g' -e 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
    orbit_config_micro_version=`$ORBIT_CONFIG $orbit_config_args --version | \
	   sed -e 's,[[^0-9.]],,g' -e 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`
    if test "x$enable_orbittest" = "xyes" ; then
      ac_save_CFLAGS="$CFLAGS"
      ac_save_LIBS="$LIBS"
      CFLAGS="$CFLAGS $ORBIT_CFLAGS"
      LIBS="$ORBIT_LIBS $LIBS"
dnl
dnl Now check if the installed ORBIT is sufficiently new. (Also sanity
dnl checks the results of orbit-config to some extent
dnl
      rm -f conf.orbittest
      AC_TRY_RUN([
#include <orb/orbit.h>
#include <stdio.h>
#include <stdlib.h>

int 
main ()
{
  int major, minor, micro;
  char *tmp_version;

  system ("touch conf.orbittest");

  /* HP/UX 9 (%@#!) writes to sscanf strings */
  tmp_version = g_strdup("$min_orbit_version");
  if (sscanf(tmp_version, "%d.%d.%d", &major, &minor, &micro) != 3) {
     printf("%s, bad version string\n", "$min_orbit_version");
     exit(1);
   }

  if ((orbit_major_version != $orbit_config_major_version) ||
      (orbit_minor_version != $orbit_config_minor_version) ||
      (orbit_micro_version != $orbit_config_micro_version))
    {
      printf("\n*** 'orbit-config --version' returned %d.%d.%d, but ORBit (%d.%d.%d)\n", 
             $orbit_config_major_version, $orbit_config_minor_version, $orbit_config_micro_version,
             orbit_major_version, orbit_minor_version, orbit_micro_version);
      printf ("*** was found! If orbit-config was correct, then it is best\n");
      printf ("*** to remove the old version of ORBit. You may also be able to fix the error\n");
      printf("*** by modifying your LD_LIBRARY_PATH enviroment variable, or by editing\n");
      printf("*** /etc/ld.so.conf. Make sure you have run ldconfig if that is\n");
      printf("*** required on your system.\n");
      printf("*** If orbit-config was wrong, set the environment variable ORBIT_CONFIG\n");
      printf("*** to point to the correct copy of orbit-config, and remove the file config.cache\n");
      printf("*** before re-running configure\n");
    } 
#if defined (ORBIT_MAJOR_VERSION) && defined (ORBIT_MINOR_VERSION) && defined (ORBIT_MICRO_VERSION)
  else if ((orbit_major_version != ORBIT_MAJOR_VERSION) ||
	   (orbit_minor_version != ORBIT_MINOR_VERSION) ||
           (orbit_micro_version != ORBIT_MICRO_VERSION))
    {
      printf("*** ORBit header files (version %d.%d.%d) do not match\n",
	     ORBIT_MAJOR_VERSION, ORBIT_MINOR_VERSION, ORBIT_MICRO_VERSION);
      printf("*** library (version %d.%d.%d)\n",
	     orbit_major_version, orbit_minor_version, orbit_micro_version);
    }
#endif /* defined (ORBIT_MAJOR_VERSION) ... */
  else
    {
      if ((orbit_major_version > major) ||
        ((orbit_major_version == major) && (orbit_minor_version > minor)) ||
        ((orbit_major_version == major) && (orbit_minor_version == minor) && (orbit_micro_version >= micro)))
      {
        return 0;
       }
     else
      {
        printf("\n*** An old version of ORBit (%d.%d.%d) was found.\n",
               orbit_major_version, orbit_minor_version, orbit_micro_version);
        printf("*** You need a version of ORBit newer than %d.%d.%d. The latest version of\n",
	       major, minor, micro);
        printf("*** ORBit is always available from ftp://ftp.orbit.org.\n");
        printf("***\n");
        printf("*** If you have already installed a sufficiently new version, this error\n");
        printf("*** probably means that the wrong copy of the orbit-config shell script is\n");
        printf("*** being found. The easiest way to fix this is to remove the old version\n");
        printf("*** of ORBit, but you can also set the ORBIT_CONFIG environment to point to the\n");
        printf("*** correct copy of orbit-config. (In this case, you will have to\n");
        printf("*** modify your LD_LIBRARY_PATH enviroment variable, or edit /etc/ld.so.conf\n");
        printf("*** so that the correct libraries are found at run-time))\n");
      }
    }
  return 1;
}
],, no_orbit=yes,[echo $ac_n "cross compiling; assumed OK... $ac_c"])
       CFLAGS="$ac_save_CFLAGS"
       LIBS="$ac_save_LIBS"
     fi
  fi
  if test "x$no_orbit" = x ; then
     AC_MSG_RESULT(yes)
     ifelse([$2], , :, [$2])     
  else
     AC_MSG_RESULT(no)
     if test "$ORBIT_CONFIG" = "no" ; then
       echo "*** The orbit-config script installed by ORBIT could not be found"
       echo "*** If ORBit was installed in PREFIX, make sure PREFIX/bin is in"
       echo "*** your path, or set the ORBIT_CONFIG environment variable to the"
       echo "*** full path to orbit-config."
     else
       if test -f conf.orbittest ; then
        :
       else
          echo "*** Could not run ORBIT test program, checking why..."
          CFLAGS="$CFLAGS $ORBIT_CFLAGS"
          LIBS="$LIBS $ORBIT_LIBS"
          AC_TRY_LINK([
#include <orb/orbit.h>
#include <stdio.h>
],      [ return ((orbit_major_version) || (orbit_minor_version) || (orbit_micro_version)); ],
        [ echo "*** The test program compiled, but did not run. This usually means"
          echo "*** that the run-time linker is not finding ORBit or finding the wrong"
          echo "*** version of ORBit. If it is not finding ORBit, you'll need to set your"
          echo "*** LD_LIBRARY_PATH environment variable, or edit /etc/ld.so.conf to point"
          echo "*** to the installed location  Also, make sure you have run ldconfig if that"
          echo "*** is required on your system"
	  echo "***"
          echo "*** If you have an old version installed, it is best to remove it, although"
          echo "*** you may also be able to get things to work by modifying LD_LIBRARY_PATH"
          echo "***"
          echo "*** If you have a RedHat 5.0 system, you should remove the ORBit package that"
          echo "*** came with the system with the command"
          echo "***"
          echo "***    rpm --erase --nodeps orbit orbit-devel" ],
        [ echo "*** The test program failed to compile or link. See the file config.log for the"
          echo "*** exact error that occured. This usually means ORBIT was incorrectly installed"
          echo "*** or that you have moved ORBit since it was installed. In the latter case, you"
          echo "*** may want to edit the orbit-config script: $ORBIT_CONFIG" ])
          CFLAGS="$ac_save_CFLAGS"
          LIBS="$ac_save_LIBS"
       fi
     fi
     ORBIT_CFLAGS=""
     ORBIT_LIBS=""
     ifelse([$3], , :, [$3])
  fi

  AC_PATH_PROG(ORBIT_IDL, orbit-idl, ifelse([$3], , :, [$3]))
  AC_SUBST(ORBIT_CFLAGS)
  AC_SUBST(ORBIT_LIBS)
  AC_SUBST(ORBIT_IDL)
  rm -f conf.orbittest
])
dnl Configure paths for XINE
dnl
dnl Copyright (C) 2001 Daniel Caujolle-Bert <segfault@club-internet.fr>
dnl  
dnl This program is free software; you can redistribute it and/or modify
dnl it under the terms of the GNU General Public License as published by
dnl the Free Software Foundation; either version 2 of the License, or
dnl (at your option) any later version.
dnl  
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl  
dnl You should have received a copy of the GNU General Public License
dnl along with this program; if not, write to the Free Software
dnl Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
dnl  
dnl  
dnl As a special exception to the GNU General Public License, if you
dnl distribute this file as part of a program that contains a configuration
dnl script generated by Autoconf, you may include it under the same
dnl distribution terms that you use for the rest of that program.
dnl  

dnl AM_PATH_XINE([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND ]]])
dnl Test for XINE, and define XINE_CFLAGS and XINE_LIBS
dnl
AC_DEFUN(AM_PATH_XINE,
[dnl 
dnl Get the cflags and libraries from the xine-config script
dnl
AC_ARG_WITH(xine-prefix,
    [  --with-xine-prefix=PFX  Prefix where XINE is installed (optional)],
            xine_config_prefix="$withval", xine_config_prefix="")
AC_ARG_WITH(xine-exec-prefix,
    [  --with-xine-exec-prefix=PFX                                                                             Exec prefix where XINE is installed (optional)],
            xine_config_exec_prefix="$withval", xine_config_exec_prefix="")
AC_ARG_ENABLE(xinetest, 
    [  --disable-xinetest      Do not try to compile and run a test XINE program],, enable_xinetest=yes)

  if test x$xine_config_exec_prefix != x ; then
     xine_config_args="$xine_config_args --exec-prefix=$xine_config_exec_prefix"
     if test x${XINE_CONFIG+set} != xset ; then
        XINE_CONFIG=$xine_config_exec_prefix/bin/xine-config
     fi
  fi
  if test x$xine_config_prefix != x ; then
     xine_config_args="$xine_config_args --prefix=$xine_config_prefix"
     if test x${XINE_CONFIG+set} != xset ; then
        XINE_CONFIG=$xine_config_prefix/bin/xine-config
     fi
  fi

  min_xine_version=ifelse([$1], ,0.5.0,$1)
  if test "x$enable_xinetest" != "xyes" ; then
    AC_MSG_CHECKING(for XINE-LIB version >= $min_xine_version)
  else
    AC_PATH_PROG(XINE_CONFIG, xine-config, no)
    AC_MSG_CHECKING(for XINE-LIB version >= $min_xine_version)
    no_xine=""
    if test "$XINE_CONFIG" = "no" ; then
      no_xine=yes
    else
      XINE_CFLAGS=`$XINE_CONFIG $xine_config_args --cflags`
      XINE_LIBS=`$XINE_CONFIG $xine_config_args --libs`
      xine_config_major_version=`$XINE_CONFIG $xine_config_args --version | \
             sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
      xine_config_minor_version=`$XINE_CONFIG $xine_config_args --version | \
             sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
      xine_config_sub_version=`$XINE_CONFIG $xine_config_args --version | \
             sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`
      xine_skin_dir=`$XINE_CONFIG $xine_config_args --skindir`
      xine_plugin_dir=`$XINE_CONFIG $xine_config_args --plugindir`
      dnl    if test "x$enable_xinetest" = "xyes" ; then
      ac_save_CFLAGS="$CFLAGS"
      ac_save_LIBS="$LIBS"
      CFLAGS="$CFLAGS $XINE_CFLAGS"
      LIBS="$XINE_LIBS $LIBS"
dnl
dnl Now check if the installed XINE is sufficiently new. (Also sanity
dnl checks the results of xine-config to some extent
dnl
      AC_LANG_SAVE()
      AC_LANG_C()
      rm -f conf.xinetest
      AC_TRY_RUN([
#include <xine.h>
#include <stdio.h>
#include <stdlib.h>

int 
main ()
{
  int major, minor, sub;
   char *tmp_version;

  system ("touch conf.xinetest");

  /* HP/UX 9 (%@#!) writes to sscanf strings */
  tmp_version = (char *) strdup("$min_xine_version");
  if (sscanf(tmp_version, "%d.%d.%d", &major, &minor, &sub) != 3) {
     printf("%s, bad version string\n", "$min_xine_version");
     exit(1);
   }

  if ((XINE_MAJOR_VERSION != $xine_config_major_version) ||
      (XINE_MINOR_VERSION != $xine_config_minor_version) ||
      (XINE_SUB_VERSION != $xine_config_sub_version))
    {
      printf("\n*** 'xine-config --version' returned %d.%d.%d, but XINE (%d.%d.%d)\n", 
             $xine_config_major_version, $xine_config_minor_version, $xine_config_sub_version,
             XINE_MAJOR_VERSION, XINE_MINOR_VERSION, XINE_SUB_VERSION);
      printf ("*** was found! If xine-config was correct, then it is best\n");
      printf ("*** to remove the old version of XINE. You may also be able to fix the error\n");
      printf("*** by modifying your LD_LIBRARY_PATH enviroment variable, or by editing\n");
      printf("*** /etc/ld.so.conf. Make sure you have run ldconfig if that is\n");
      printf("*** required on your system.\n");
      printf("*** If xine-config was wrong, set the environment variable XINE_CONFIG\n");
      printf("*** to point to the correct copy of xine-config, and remove the file config.cache\n");
      printf("*** before re-running configure\n");
    } 
  else
    {
      if ((XINE_MAJOR_VERSION > major) ||
        ((XINE_MAJOR_VERSION == major) && (XINE_MINOR_VERSION > minor)) ||
        ((XINE_MAJOR_VERSION == major) && (XINE_MINOR_VERSION == minor) && (XINE_SUB_VERSION >= sub)))
      {
        return 0;
       }
     else
      {
        printf("\n*** An old version of XINE (%d.%d.%d) was found.\n",
               XINE_MAJOR_VERSION, XINE_MINOR_VERSION, XINE_SUB_VERSION);
        printf("*** You need a version of XINE newer than %d.%d.%d. The latest version of\n",
	       major, minor, sub);
        printf("*** XINE is always available from:\n");
        printf("***        http://xine.sourceforge.net\n");
        printf("***\n");
        printf("*** If you have already installed a sufficiently new version, this error\n");
        printf("*** probably means that the wrong copy of the xine-config shell script is\n");
        printf("*** being found. The easiest way to fix this is to remove the old version\n");
        printf("*** of XINE, but you can also set the XINE_CONFIG environment to point to the\n");
        printf("*** correct copy of xine-config. (In this case, you will have to\n");
        printf("*** modify your LD_LIBRARY_PATH enviroment variable, or edit /etc/ld.so.conf\n");
        printf("*** so that the correct libraries are found at run-time))\n");
      }
    }
  return 1;
}
],, no_xine=yes,[echo $ac_n "cross compiling; assumed OK... $ac_c"])
       CFLAGS="$ac_save_CFLAGS"
       LIBS="$ac_save_LIBS"
     fi
    fi
    if test "x$no_xine" = x ; then
       AC_MSG_RESULT(yes)
       ifelse([$2], , :, [$2])     
    else
      AC_MSG_RESULT(no)
      if test "$XINE_CONFIG" = "no" ; then
        echo "*** The xine-config script installed by XINE could not be found"
        echo "*** If XINE was installed in PREFIX, make sure PREFIX/bin is in"
        echo "*** your path, or set the XINE_CONFIG environment variable to the"
        echo "*** full path to xine-config."
      else
        if test -f conf.xinetest ; then
          :
        else
          echo "*** Could not run XINE test program, checking why..."
          CFLAGS="$CFLAGS $XINE_CFLAGS"
          LIBS="$LIBS $XINE_LIBS"
          AC_TRY_LINK([
#include <xine.h>
#include <stdio.h>
],      [ return ((XINE_MAJOR_VERSION) || (XINE_MINOR_VERSION) || (XINE_SUB_VERSION)); ],
        [ echo "*** The test program compiled, but did not run. This usually means"
          echo "*** that the run-time linker is not finding XINE or finding the wrong"
          echo "*** version of XINE. If it is not finding XINE, you'll need to set your"
          echo "*** LD_LIBRARY_PATH environment variable, or edit /etc/ld.so.conf to point"
          echo "*** to the installed location  Also, make sure you have run ldconfig if that"
          echo "*** is required on your system"
	  echo "***"
          echo "*** If you have an old version installed, it is best to remove it, although"
          echo "*** you may also be able to get things to work by modifying LD_LIBRARY_PATH"
          echo "***"],
        [ echo "*** The test program failed to compile or link. See the file config.log for the"
          echo "*** exact error that occured. This usually means XINE was incorrectly installed"
          echo "*** or that you have moved XINE since it was installed. In the latter case, you"
          echo "*** may want to edit the xine-config script: $XINE_CONFIG" ])
          CFLAGS="$ac_save_CFLAGS"
          LIBS="$ac_save_LIBS"
        fi
      fi
    XINE_CFLAGS=""
    XINE_LIBS=""
    ifelse([$3], , :, [$3])
  fi
  AC_SUBST(XINE_CFLAGS)
  AC_SUBST(XINE_LIBS)
  AC_LANG_RESTORE()
  rm -f conf.xinetest
])
dnl Configure path and dependencies for aalib.
dnl
dnl Copyright (C) 2001 Daniel Caujolle-Bert <segfault@club-internet.fr>
dnl  
dnl This program is free software; you can redistribute it and/or modify
dnl it under the terms of the GNU General Public License as published by
dnl the Free Software Foundation; either version 2 of the License, or
dnl (at your option) any later version.
dnl  
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl  
dnl You should have received a copy of the GNU General Public License
dnl along with this program; if not, write to the Free Software
dnl Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
dnl  
dnl  
dnl As a special exception to the GNU General Public License, if you
dnl distribute this file as part of a program that contains a configuration
dnl script generated by Autoconf, you may include it under the same
dnl distribution terms that you use for the rest of that program.
dnl  
dnl AM_PATH_AALIB([MINIMUM-VERSION, [ACTION-IF-FOUND [,ACTION-IF-NOT-FOUND ]]])
dnl Test for AALIB, and define AALIB_CFLAGS and AALIB_LIBS, AALIB_STATIC_LIBS.
dnl
dnl ***********************
dnl 19/08/2001
dnl   * use aalib-config instead of aainfo now.
dnl 17/06/2001 
dnl   * First shot
dnl
AC_DEFUN(AM_PATH_AALIB,
[dnl 
dnl
AC_ARG_WITH(aalib-prefix,
    [  --with-aalib-prefix=PFX Prefix where AALIB is installed (optional)],
            aalib_config_prefix="$withval", aalib_config_prefix="")
AC_ARG_WITH(aalib-exec-prefix,
    [  --with-aalib-exec-prefix=PFX                                                                            Exec prefix where AALIB is installed (optional)],
            aalib_config_exec_prefix="$withval", aalib_config_exec_prefix="")
AC_ARG_ENABLE(aalib-test, 
    [  --disable-aalibtest     Do not try to compile and run a test AALIB program],, enable_aalibtest=yes)

  if test x$aalib_config_exec_prefix != x ; then
     aalib_config_args="$aalib_config_args --exec-prefix=$aalib_config_exec_prefix"
     if test x${AALIB_CONFIG+set} != xset ; then
        AALIB_CONFIG=$aalib_config_exec_prefix/bin/aalib-config
     fi
  fi
  if test x$aalib_config_prefix != x ; then
     aalib_config_args="$aalib_config_args --prefix=$aalib_config_prefix"
     if test x${AALIB_CONFIG+set} != xset ; then
        AALIB_CONFIG=$aalib_config_prefix/bin/aalib-config
     fi
  fi

  min_aalib_version=ifelse([$1], ,1.2,$1)

  if test x"$enable_aalibtest" != "xyes"; then
    AC_MSG_CHECKING(for AALIB version >= $min_aalib_version)
  else
    AC_PATH_PROG(AALIB_CONFIG, aalib-config, no)
    AC_MSG_CHECKING(for AALIB version >= $min_aalib_version)
    no_aalib=""
    if test "$AALIB_CONFIG" = "no" ; then
      no_aalib=yes
    else
      AALIB_CFLAGS=`$AALIB_CONFIG $aalib_config_args --cflags`
      AALIB_LIBS=`$AALIB_CONFIG $aalib_config_args --libs`
      aalib_config_major_version=`$AALIB_CONFIG $aalib_config_args --version | \
             sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
      aalib_config_minor_version=`$AALIB_CONFIG $aalib_config_args --version | \
             sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
      aalib_config_sub_version=`$AALIB_CONFIG $aalib_config_args --version | \
             sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`

      ac_save_CFLAGS="$CFLAGS"
      ac_save_LIBS="$LIBS"
      CFLAGS="$CFLAGS $AALIB_CFLAGS"
      LIBS="$AALIB_LIBS $LIBS"

dnl
dnl Now check if the installed AALIB is sufficiently new. (Also sanity
dnl checks the results of aalib-config to some extent
dnl
      AC_LANG_SAVE()
      AC_LANG_C()
      rm -f conf.xinetest
      AC_TRY_RUN([
#include <stdio.h>
#include <stdlib.h>
#include <aalib.h>

int main () {
  int major, minor;
   char *tmp_version;

  system ("touch conf.xinetest");

  /* HP/UX 9 (%@#!) writes to sscanf strings */
  tmp_version = (char *) strdup("$min_aalib_version");
  if (sscanf(tmp_version, "%d.%d", &major, &minor) != 2) {
     printf("%s, bad version string\n", "$min_aalib_version");
     exit(1);
  }

  if ((AA_LIB_VERSION > major) || ((AA_LIB_VERSION == major) && 
#ifdef AA_LIB_MINNOR
     (AA_LIB_MINNOR >= minor)
#else
     (AA_LIB_MINOR >= minor)
#endif
     )) {
     return 0;
  }
  else {
#ifdef AA_LIB_MINNOR
     printf("\n*** An old version of AALIB (%d.%d) was found.\n", AA_LIB_VERSION, AA_LIB_MINNOR);
#else
printf("\n*** An old version of AALIB (%d.%d) was found.\n", AA_LIB_VERSION, AA_LIB_MINOR);
#endif
     printf("*** You need a version of AALIB newer than %d.%d. The latest version of\n", major, minor);
     printf("*** AALIB is always available from:\n");
     printf("***        http://www.ta.jcu.cz://aa\n");
     printf("***\n");
  }
  return 1;
}
],, no_aalib=yes,[echo $ac_n "cross compiling; assumed OK... $ac_c"])
       CFLAGS="$ac_save_CFLAGS"
       LIBS="$ac_save_LIBS"
     fi
    fi
    if test "x$no_aalib" = x; then
       AC_MSG_RESULT(yes)
       ifelse([$2], , :, [$2])     
    else
      AC_MSG_RESULT(no)
      if test "$AALIB_CONFIG" = "no"; then
        echo "*** The aalib-config program installed by AALIB could not be found"
        echo "*** If AALIB was installed in PREFIX, make sure PREFIX/bin is in"
        echo "*** your path, or use --with-aalib-prefix to set the prefix"
	echo "*** where AALIB is installed."
      else
        if test -f conf.xinetest ; then
          :
        else
          echo "*** Could not run AALIB test program, checking why..."
          CFLAGS="$CFLAGS $AALIB_CFLAGS"
          LIBS="$LIBS $AALIB_LIBS"
          AC_TRY_LINK([
#include <stdio.h>
#include <aalib.h>
],      [ 
          return ((AA_LIB_VERSION) || 
#ifdef AA_LIB_MINNOR
                  (AA_LIB_MINNOR)
#else
                  (AA_LIB_MINOR)
#endif
                  ); ],
        [ echo "*** The test program compiled, but did not run. This usually means"
          echo "*** that the run-time linker is not finding AALIB or finding the wrong"
          echo "*** version of AALIB. If it is not finding AALIB, you'll need to set your"
          echo "*** LD_LIBRARY_PATH environment variable, or edit /etc/ld.so.conf to point"
          echo "*** to the installed location  Also, make sure you have run ldconfig if that"
          echo "*** is required on your system"
	  echo "***"
          echo "*** If you have an old version installed, it is best to remove it, although"
          echo "*** you may also be able to get things to work by modifying LD_LIBRARY_PATH"
          echo "***"],
        [ echo "*** The test program failed to compile or link. See the file config.log for the"
          echo "*** exact error that occured. This usually means AALIB was incorrectly installed"
          echo "*** or that you have moved AALIB since it was installed." ])
          CFLAGS="$ac_save_CFLAGS"
          LIBS="$ac_save_LIBS"
        fi
      fi
    AALIB_CFLAGS=""
    AALIB_LIBS=""
    ifelse([$3], , :, [$3])
  fi
  AC_SUBST(AALIB_CFLAGS)
  AC_SUBST(AALIB_LIBS)
  AC_LANG_RESTORE()
  rm -f conf.xinetest
])

