#!/bin/sh

#if [ $# -ne 1 ] ; then
#   echo "usage: $0 version number"
#   exit 1
#fi

# Some rpm checks
RPMVERSION=`rpm --version | tr [A-Z] [a-z] | sed -e 's/[a-z]//g' -e 's/\.//g' -e 's/ //g'`

# rpm version 4 return 40
if [ `expr $RPMVERSION` -lt 100 ]; then
  RPMVERSION=`expr $RPMVERSION \* 10`
fi

if [ `expr $RPMVERSION` -lt 400 ]; then
  RPM_BA="rpm -ba -ta ./xine-ui-0.9.0.tar.gz"
  RPM_BB="rpm -bb -ta ./xine-ui-0.9.0.tar.gz"
else
  RPM_BA="rpm -ta ./xine-ui-0.9.0.tar.gz -ba"
  RPM_BB="rpm -ta ./xine-ui-0.9.0.tar.gz -bb"
fi

##VERSION="0.9.0"

echo "Creating tarball..."
rm -f config.cache && ./cvscompile.sh && make dist
##mv -f xine-ui-0.9.0.tar.gz  xine-ui-0.9.0.tar.gz
rm -rf rpms
mkdir rpms

echo "*****************************************************"
echo
echo "building rpm for xine-ui 0.9.0"
echo 
echo "current architecture:pentiumpro"
echo "rpms will be copied to ./rpms directory"
echo
echo "*****************************************************"

export XINE_BUILD=i686-pc-linux-gnu

eval $RPM_BA

cp '/usr/src/redhat/SRPMS/xine-ui-0.9.0-0.src.rpm' ./rpms/
mv '/usr/src/redhat/RPMS/i386/xine-ui-0.9.0-0.i386.rpm' './rpms/xine-ui-0.9.0-0.i686.rpm'
mv '/usr/src/redhat/RPMS/i386/xine-ui-aa-0.9.0-0.i386.rpm' './rpms/xine-ui-aa-0.9.0-0.i686.rpm'

echo "*****************************************************"
echo
echo "building rpm for xine-ui 0.9.0"
echo 
echo "current architecture:k6"
echo "rpms will be copied to ./rpms directory"
echo
echo "*****************************************************"

export XINE_BUILD=k6-pc-linux-gnu

eval $RPM_BB

mv '/usr/src/redhat/RPMS/i386/xine-ui-0.9.0-0.i386.rpm' './rpms/xine-ui-0.9.0-0.k6.rpm'
mv '/usr/src/redhat/RPMS/i386/xine-ui-aa-0.9.0-0.i386.rpm' './rpms/xine-ui-aa-0.9.0-0.k6.rpm'

echo "*****************************************************"
echo
echo "building rpm for xine-ui 0.9.0"
echo 
echo "current architecture:pentium"
echo "rpms will be copied to ./rpms directory"
echo
echo "*****************************************************"

export XINE_BUILD=i586-pc-linux-gnu

eval $RPM_BB

mv '/usr/src/redhat/RPMS/i386/xine-ui-0.9.0-0.i386.rpm' './rpms/xine-ui-0.9.0-0.i586.rpm'
mv '/usr/src/redhat/RPMS/i386/xine-ui-aa-0.9.0-0.i386.rpm' './rpms/xine-ui-aa-0.9.0-0.i586.rpm'

echo "*****************************************************"
echo
echo "building rpm for xine-ui 0.9.0"
echo 
echo "current architecture:k7"
echo "rpms will be copied to ./rpms directory"
echo
echo "*****************************************************"

export XINE_BUILD=athlon-pc-linux-gnu

eval $RPM_BB

mv '/usr/src/redhat/RPMS/i386/xine-ui-0.9.0-0.i386.rpm' './rpms/xine-ui-0.9.0-0.k7.rpm'
mv '/usr/src/redhat/RPMS/i386/xine-ui-aa-0.9.0-0.i386.rpm' './rpms/xine-ui-aa-0.9.0-0.k7.rpm'

echo "Done."
