/*
 *   libcddb - CDDB Interface Library for xmcd/cda
 *
 *      This library implements an interface to access the "classic"
 *      CDDB1 services.
 *
 *   Copyright (C) 1993-2001  Ti Kan
 *   E-mail: xmcd@amb.org
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef _GENRETBL_H_
#define _GENRETBL_H_

#ifndef LINT
static char     *_genretbl_h_ident_ = "@(#)genretbl.h	7.2 01/04/09";
#endif


/* CDDB1 <-> CDDB2 genre map */
fcddb_gmap_t	fcddb_genre_map[] = {
    {	"blues",
	{ "28",		"Blues"				},
	{ "32",		"General Blues"			}
    },
    {	"classical",
	{ "40",		"Classical"			},
	{ "46",		"General Classical"		}
    },
    {	"country",
	{ "55",		"Country"			},
	{ "60",		"General Country"		}
    },
    {	"data",
	{ "70",		"Data"				},
	{ "71",		"General Data"			}
    },
    {	"folk",
	{ "94",		"Folk"				},
	{ "96",		"General Folk"			}
    },
    {	"jazz",
	{ "153",	"Jazz"				},
	{ "160",	"General Jazz"			}
    },
    {	"misc",
	{ "220",	"Unclassifiable"		},
	{ "221",	"General Unclassifiable"	}
    },
    {	"newage",
	{ "166",	"New Age"			},
	{ "169",	"General New Age"		}
    },
    {	"reggae",
	{ "222",	"World"				},
	{ "246",	"Reggae"			}
    },
    {	"rock",
	{ "180",	"Rock"				},
	{ "191",	"General Rock"			}
    },
    {	"soundtrack",
	{ "213",	"Soundtrack"			},
	{ "214",	"General Soundtrack"		}
    },
    {	NULL,
	{ NULL,		NULL				},
	{ NULL,		NULL				}
    }
};


#endif	/* _GENRETBL_H_ */

