/*
 *   cdda - CD Digital Audio support
 *
 *   Copyright (C) 1993-2002  Ti Kan
 *   E-mail: xmcd@amb.org
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __GENWRITE_H__
#define __GENWRITE_H__

#ifndef LINT
static char *_genwrite_h_ident_ = "@(#)genwrite.h	7.12 02/04/06";
#endif

#if defined(CDDA_SYSVIPC)

/* Function prototypes */
extern bool_t		gen_set_eid(cd_state_t *);
extern bool_t		gen_reset_eid(cd_state_t *);
extern int		gen_open_file(cd_state_t *, char *, int, mode_t,
					byte_t, word32_t);
extern void		gen_close_file(cd_state_t *, int, byte_t);
extern int		gen_open_pipe(cd_state_t *, char *, pid_t *,
					byte_t, word32_t);
extern void		gen_close_pipe(cd_state_t *, int);
extern bool_t		gen_write_au_hdr(cd_state_t *, int, word32_t);
extern bool_t		gen_write_wav_hdr(cd_state_t *, int, word32_t);
extern bool_t		gen_write_aiff_hdr(cd_state_t *, int, word32_t);
extern bool_t		gen_write_aifc_hdr(cd_state_t *, int, word32_t);
extern bool_t		gen_write_chunk(cd_state_t *, int, char *,
					byte_t *, size_t);
extern void		gen_byteswap(byte_t *, byte_t *, size_t);
extern void		gen_chroute(int, sword16_t *, size_t);
extern void		gen_write_init(void);

#endif	/* CDDA_SYSVIPC */

#endif	/* __GENWRITE_H__ */

