/*
 *   cdda - CD Digital Audio support
 *
 *   Copyright (C) 1993-2002  Ti Kan
 *   E-mail: xmcd@amb.org
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 *   OSS (Open Sound System) and Linux sound driver support
 */
#ifndef	__OSSWRITE_H__
#define	__OSSWRITE_H__

#ifndef LINT
static char *_osswrite_h_ident_ = "@(#)osswrite.h	7.6 02/04/06";
#endif

#if defined(CDDA_WR_OSS) && defined(CDDA_SYSVIPC)

#define DEFAULT_DEV_DSP		"/dev/dsp"	/* Default audio device */


/* Data structure for some audio parameters */
typedef struct {
	int	fmt;		/* Sample format: e.g., AFMT_S16_LE */
	int	nch;		/* Mode: mono = 1, stereo = 2 */
	int	samp;		/* Sampling rate in Hz */
	int	vol0;		/* Channel 0 volume */
	int	vol1;		/* Channel 1 volume */
} ossaudio_info_t;


/* Exported function prototypes */
extern word32_t	oss_writeinit(void);
extern bool_t	oss_write(byte_t, byte_t, curstat_t *);

#else

#define oss_writeinit	NULL
#define oss_write	NULL

#endif	/* CDDA_WR_OSS CDDA_SYSVIPC */

#endif	/* __OSSWRITE_H__ */

