/*
 *   cdda - CD Digital Audio support
 *
 *   Copyright (C) 1993-2002  Ti Kan
 *   E-mail: xmcd@amb.org
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 *   SCSI pass-through CDDA read support
 */
#ifndef	__SCSIREAD_H__
#define	__SCSIREAD_H__

#ifndef LINT
static char *_scsiread_h_ident_ = "@(#)scsiread.h	7.2 02/03/15";
#endif

#if defined(CDDA_RD_SCSIPT) && defined(CDDA_SYSVIPC)


/* Defines for the addr_format field of the scsi_readaudio_t structure */
#define READFMT_LBA	0x1
#define READFMT_MSF	0x2


/* Read audio job structure */
typedef struct scsi_readaudio {
	lmsf_t		pos;
	int		nframes;
	byte_t		*buf;
	byte_t		addrfmt;
} scsi_readaudio_t;


/* Exported function prototypes */
extern word32_t	spt_readinit(void);
extern bool_t	spt_read(int);

#else

#define spt_readinit	NULL
#define spt_read	NULL

#endif	/* CDDA_RD_SCSIPT CDDA_SYSVIPC */

#endif	/* __SCSIREAD_H__ */

