/*
 *   cdda - CD Digital Audio support
 *
 *   Copyright (C) 1993-2002  Ti Kan
 *   E-mail: xmcd@amb.org
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef LINT
static char *_sem_c_ident_ = "@(#)sem.c	7.20 02/04/05";
#endif

#include "common_d/appenv.h"
#include "common_d/util.h"
#include "cdda_d/cdda.h"
#include "cdda_d/sysvipc.h"

#ifdef CDDA_SYSVIPC

/* Semaphore functions */

#include "cdda_d/sem.h"

extern appdata_t	app_data;
extern FILE		*errfp;


STATIC bool_t
cdda_semop(int semid, struct sembuf *sops, size_t nsops)
{
	int	cnt = 0;

	/* If interrupted, repeat */
	do {
		errno = 0;
		if (semop(semid, sops, nsops) >= 0)
			return TRUE;
	} while (errno == EINTR && ++cnt < CDDA_INTR_MAX);

	return FALSE;
}


/*
 * cdda_waitsem
 *	Waits for a semaphore, decrementing its value.
 *
 * Args:
 *	semid - Semaphore id
 *	num   - Semaphore to wait on
 *
 * Return:
 *	Nothing.
 */
void
cdda_waitsem(int semid, int num)
{
	struct sembuf	p_buf;

	p_buf.sem_num = (short) num;
	p_buf.sem_op = -1;
	p_buf.sem_flg = 0;

	while (!cdda_semop(semid, &p_buf, 1)) {
		if (errno == ERANGE) {
			semun_t	arg;

			arg.val = 0;
			arg.buf = NULL;
			arg.array = NULL;

			(void) semctl(semid, num, SETVAL, arg);
		}
		else {
			DBGPRN(DBG_DEVIO)(errfp,
			    "cdda_waitsem: semop failed on %d (errno=%d)\n",
			    num, errno);
			break;
		}
	}
}


/*
 * cdda_postsem
 *	Release a sempahore, incrementing its value.
 *
 * Arguments:
 *	semid - Semaphore id
 *	num   - Semaphore to increment
 *
 * Return:
 *	Nothing.
 */
void
cdda_postsem(int semid, int num)
{
	struct sembuf	v_buf;

	v_buf.sem_num = (short) num;
	v_buf.sem_op = 1;
	v_buf.sem_flg = 0;

	while (!cdda_semop(semid, &v_buf, 1)) {
		if (errno == ERANGE) {
			semun_t	arg;

			arg.val = 0;
			arg.buf = NULL;
			arg.array = NULL;

			(void) semctl(semid, num, SETVAL, arg);
		}
		else {
			DBGPRN(DBG_DEVIO)(errfp,
			    "cdda_postsem: semop failed on %d (errno=%d)\n",
			    num, errno);
			break;
		}
	}
}

#endif	/* CDDA_SYSVIPC */

