/*
 *   cdda - CD Digital Audio support
 *
 *   Copyright (C) 1993-2002  Ti Kan
 *   E-mail: xmcd@amb.org
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 *   Sun Solaris support
 *
 *   This software fragment contains code that interfaces the
 *   application to the Solaris operating environment.  The name "Sun"
 *   and "Solaris" are used here for identification purposes only.
 *
 *   Contributing author: Darragh O'Brien <darragh.obrien@sun.com>
 */
#ifndef	__SOLWRITE_H__
#define	__SOLWRITE_H__

#ifndef LINT
static char *_solwrite_h_ident_ = "@(#)solwrite.h	7.22 02/05/03";
#endif

#if defined(CDDA_WR_SOL) && defined(CDDA_SYSVIPC)

#define DEFAULT_DEV_AUDIO	"/dev/audio"	/* default audio device */


/* Adapted from <sys/audio.h> and put here because audio.h is not found
 * on all systems.  Renamed from AUDIO_INIT to avoid clash with other
 * platforms.
 */
#define SOL_AUDIO_INIT(I, S) {						\
		byte_t *__x__;						\
		for (__x__ = (byte_t *)(I);				\
			__x__ < (((byte_t *)(I)) + (S));		\
				*__x__++ = (byte_t)~0);		\
		}

/* Exported function prototypes */
extern word32_t	sol_writeinit(void);
extern bool_t	sol_write(byte_t, byte_t, curstat_t *);

#else

#define sol_writeinit	NULL
#define sol_write	NULL

#endif	/* CDDA_WR_SOL CDDA_SYSVIPC */

#endif	/* __SOLWRITE_H__ */

