/*
 *   cdda - CD Digital Audio support
 *
 *   Copyright (C) 1993-2002  Ti Kan
 *   E-mail: xmcd@amb.org
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __SYSVIPC_H__
#define __SYSVIPC_H__

#ifndef LINT
static char *_sysvipc_h_ident_ = "@(#)sysvipc.h	7.25 02/05/14";
#endif

#ifdef CDDA_SYSVIPC

#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/sem.h>

/* Shared memory keys */
#define	SHMKEY			1111
#define	SEMKEY			2222

/* Semaphores */
#define LOCK			0
#define ROOM			1
#define DATA			2

#if !defined(linux) && !(defined(sun) && !defined(SVR4)) && \
    !defined(__FreeBSD__) && !defined(__OpenBSD__) && !defined(__NetBSD__) && \
    !defined(__bsdi__)

/* Semaphore arg */
union semun {
	int		val;
	struct semid_ds	*buf;
	unsigned short	*array;
};

#endif	/* linux sun __FreeBSD__ __OpenBSD__ __NetBSD__ __bsdi__ */

typedef union semun	semun_t;

/* Shared memory and semaphore permissions */
#ifdef HAS_SETEUID
#define IPC_PERMS	0600
#else
#define IPC_PERMS	0666
#endif


/* Function prototypes */
extern word32_t	cdda_sysvipc_capab(void);
extern bool_t	cdda_sysvipc_init(curstat_t *s);
extern void	cdda_sysvipc_halt(int, curstat_t *);
extern bool_t	cdda_sysvipc_play(int, curstat_t *, int, int);
extern bool_t	cdda_sysvipc_pause_resume(int, curstat_t *, bool_t);
extern bool_t	cdda_sysvipc_stop(int, curstat_t *);
extern int	cdda_sysvipc_vol(int, curstat_t *, int, bool_t);
extern bool_t	cdda_sysvipc_chroute(int, curstat_t *);
extern bool_t	cdda_sysvipc_getstatus(int, curstat_t *, cdstat_t *);
extern void	cdda_sysvipc_debug(word32_t);

extern int	cdda_rw_initipc(cd_state_t *);
extern byte_t	*cdda_rd_corrjitter(cd_state_t *);
extern void	cdda_rd_setcurtrk(cd_state_t *, int);
extern int	cdda_wr_getcurtrk(cd_state_t *, int);

#else

#define cdda_sysvipc_capab		NULL
#define cdda_sysvipc_init		NULL
#define cdda_sysvipc_halt		NULL
#define cdda_sysvipc_play		NULL
#define cdda_sysvipc_pause_resume	NULL
#define cdda_sysvipc_stop		NULL
#define cdda_sysvipc_vol		NULL
#define cdda_sysvipc_chroute		NULL
#define cdda_sysvipc_getstatus		NULL
#define cdda_sysvipc_debug		NULL

#endif	/* CDDA_SYSVIPC */

#endif	/* __SYSVIPC_H__ */

