/*
 *   util.h - Common utility routines for xmcd, cda and libdi.
 *
 *   xmcd  - Motif(tm) CD Audio Player
 *   cda   - Command-line CD Audio Player
 *   libdi - CD Audio Player Device Interface Library
 *
 *
 *   Copyright (C) 1993-2002  Ti Kan
 *   E-mail: xmcd@amb.org
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef __UTIL_H__
#define __UTIL_H__

#ifndef LINT
static char *_util_h_ident_ = "@(#)util.h	6.38 02/05/04";
#endif


/* Directory path name convention */
#ifdef __VMS
#define DIR_BEG		'['		/* Directory start */
#define DIR_SEP		'.'		/* Directory separator */
#define DIR_END		']'		/* Directory end */
#define CUR_DIR		"[]"		/* Current directory */
#else
#define DIR_BEG		'/'		/* Directory start */
#define DIR_SEP		'/'		/* Directory separator */
#define DIR_END		'/'		/* Directory end */
#define CUR_DIR		"."		/* Current directory */
#endif

/* Utility macros */
#define SQR(x)		((x) * (x))	/* Compute the square of a number */

/* Debugging macros */
#define DBG_GEN		0x01		/* General debugging */
#define DBG_DEVIO	0x02		/* Device I/O debugging */
#define DBG_CDI		0x04		/* CD information load debugging */
#define DBG_UI		0x08		/* User interface debugging */
#define DBG_RMT		0x10		/* Remote control debugging */
#define DBG_ALL		0xff		/* All debug levels */

#define DBGPRN(x)	if (app_data.debug & (x)) (void) fprintf
#define DBGDUMP(x)	if (app_data.debug & (x)) util_dbgdump

#define EXE_ERR		0xdeadbeef	/* Magic retcode for util_runcmd() */

/* Return bitmap of util_urlchk */
#define IS_LOCAL_URL		0x01
#define IS_REMOTE_URL		0x02
#define NEED_PREPEND_HTTP	0x10
#define NEED_PREPEND_FTP	0x20
#define NEED_PREPEND_MAILTO	0x40

/* Used for the dir parameter of util_vms_urlconv */
#define UNIX_2_VMS	1
#define VMS_2_UNIX	2


/* Public function prototypes */
extern void		util_init(void);
extern void		util_start(void);
extern void		util_onalrm(int);
extern bool_t		util_newstr(char **, char *);
extern uid_t		util_get_ouid(void);
extern gid_t		util_get_ogid(void);
extern bool_t		util_set_ougid(void);
extern struct utsname	*util_get_uname(void);
extern sword32_t	util_ltobcd(sword32_t);
extern sword32_t	util_bcdtol(sword32_t);
extern bool_t		util_stob(char *);
extern char		*util_basename(char *);
extern char		*util_dirname(char *);
extern char		*util_loginname(void);
extern char		*util_homedir(uid_t);
extern char		*util_uhomedir(char *);
extern bool_t		util_mkdir(char *, mode_t);
extern void		util_setperm(char *, char *);
extern char		*util_monname(int);
extern bool_t		util_isexecutable(char *);
extern bool_t		util_checkcmd(char *);
extern int		util_runcmd(char *, void (*)(int), int);
extern int		util_isqrt(int);
extern void		util_blktomsf(word32_t, byte_t *, byte_t *, byte_t *,
				      word32_t);
extern void		util_msftoblk(byte_t, byte_t, byte_t, word32_t *,
				      word32_t);
extern int		util_taper_vol(int);
extern int		util_untaper_vol(int);
extern int		util_scale_vol(int);
extern int		util_unscale_vol(int);
extern void		util_delayms(unsigned long);
extern char		*util_strstr(char *s1, char *s2);
extern int		util_strcasecmp(char *, char *);
extern int		util_strncasecmp(char *, char *, int);
extern char		*util_text_reduce(char *);
extern char		*util_cgi_xlate(char *);
extern int		util_urlchk(char *, char **, int *);
extern void		util_html_fputs(char *, FILE *, bool_t, char *, int);
extern void		*util_open_lconv(char *, char *);
extern void		util_close_lconv(void *);
extern bool_t		util_do_lconv(void *, char *, char **);
extern word16_t		util_bswap16(word16_t);
extern word32_t		util_bswap24(word32_t);
extern word32_t		util_bswap32(word32_t);
extern word16_t		util_lswap16(word16_t);
extern word32_t		util_lswap24(word32_t);
extern word32_t		util_lswap32(word32_t);
extern void		util_dbgdump(char *, byte_t *, int);

#ifdef __VMS
extern DIR		*util_opendir(char *);
extern void		util_closedir(DIR *);
extern struct dirent	*util_readdir(DIR *);
extern pid_t		util_waitpid(pid_t, int *, int);
extern int		util_link(char *, char *);
extern int		util_unlink(char *);
extern char		*util_vms_urlconv(char *, int);
#endif

#ifdef MEM_DEBUG
void			*util_dbg_malloc(char *name, size_t size);
void			*util_dbg_realloc(char *name, void *ptr, size_t size);
void			*util_dbg_calloc(char *name, size_t nelem,
					 size_t elsize);
void			util_dbg_free(void *ptr);
#endif

#endif	/* __UTIL_H__ */


