$!
$! @(#)genidx.com	6.13 02/05/06
$!
$! Generate xmcd Local Discography per-category index files.  This is the
$! equivalent of genidx.sh for use on the OpenVMS platform.
$! OpenVMS versions: 6.0 and later, tested with 7.2 on VAX(tm) machines
$!                   and 7.2-1 as well as 7.3 on Alpha(tm) machines
$!
$!    xmcd  - Motif(tm) CD Audio Player
$!    cda   - Command-line CD Audio Player
$!    libdi - CD Audio Player Device Interface Library
$!
$!    Copyright (C) 1993-2002  Ti Kan
$!    E-mail: xmcd@amb.org
$!    Contributing author: Michael Monscheuer
$!    E-mail: Monscheuer@t-online.de
$!
$!    This program is free software; you can redistribute it and/or modify
$!    it under the terms of the GNU General Public License as published by
$!    the Free Software Foundation; either version 2 of the License, or
$!    (at your option) any later version.
$!
$!    This program is distributed in the hope that it will be useful,
$!    but WITHOUT ANY WARRANTY; without even the implied warranty of
$!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
$!    GNU General Public License for more details.
$!
$!    You should have received a copy of the GNU General Public License
$!    along with this program; if not, write to the Free Software
$!    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
$!
$!    -------------------------------------------------------------------
$!
$!	First off, some definitions for output formatting, then check out
$!      the existance of the logical name $DISCOGDIR which should point
$!	at xmcd's [.discog] directory. In case the logical does not exist
$!	inform the user and exit.
$!
$	CR[0,8]=13
$	LF[0,8]=10
$	BELL[0,8]=7
$	IF F$VERIFY()
$	 THEN
$	  CR = "<CR>"
$	  LF = "<LF>"
$	  BELL = "^G"
$	ENDIF
$	IF F$TRNLNM("$DISCOGDIR") .EQS. "" 
$	 THEN
$	  WRITE SYS$OUTPUT "''BELL'''CR'''LF'%GIX-F-NLNM, no logical name match, logical $DISCOGDIR not defined."
$	  EXIT
$	ENDIF
$!
$!	Setup symbol DISCOGDIR for this procedure's internal use derived 
$!	from the logical name $DISCOGDIR. Set default to this directory
$!	and start looking for what is to be processed.
$!
$	IF P2 .NES. "RUN_SILENT" THEN WRITE SYS$OUTPUT "''CR'''LF'%GIX-I-GENIDX, generating xmcd Local Discography category index."
$	ENVI = F$ENVIRONMENT("DEFAULT")
$	IF F$LOCATE("<",ENVI) .NE. F$LENGTH(ENVI) THEN SET DEFAULT []
$	ENVI = F$ENVIRONMENT("DEFAULT")
$	IDENT = F$ENVIRONMENT("PROCEDURE")
$	IDENT = IDENT - F$PARSE(IDENT,,,"VERSION") + ";0"
$	SET DEFAULT $DISCOGDIR:[000000]
$	DISCOGDIR = F$TRNLNM("$DISCOGDIR")
$	DISK = F$ELEMENT(0,":",DISCOGDIR)
$	DISCOGDIR = DISCOGDIR - "''DISK':[" - "]"
$	DIR = ""
$ GETDIR:
$	NAM = F$ELEMENT(0,".",DISCOGDIR)
$	IF NAM .EQS. "" THEN GOTO GOTDIR
$	DIR = DIR + "/''NAM'"
$	DISCOGDIR = DISCOGDIR - "''NAM'."
$	GOTO GETDIR
$ GOTDIR:
$	DISCOGDIR = "''DISK'''DIR'"
$!
$!	Delete existing main index file and create a new one, then start
$!	looking for meta- and subgenre directories. If P1 is not present, 
$!	create all index files, otherwise only create main index file and 
$!	subgenre index file as specified in P1.
$!	
$	IF F$SEARCH("INDEX.HTML") .NES. "" THEN DELETE/NOCONFIRM INDEX.HTML;*
$	IF P2 .NES. "RUN_SILENT" THEN WRITE SYS$OUTPUT "''CR'''LF'%GIX-S-IDXMAI, generating xmcd Local Discography main index."
$	OPEN/WRITE 1 INDEX.HTML
$	WRITE 1 "<!-- xmcd Local Discography index"
$	WRITE 1 "     DO NOT EDIT: Generated by GENIDX.COM"
$	WRITE 1 "     Copyright (C) 1993-2002 Ti Kan"
$	WRITE 1 "     E-mail: xmcd@amb.org URL: http://www.amb.org/xmcd/"
$	WRITE 1 "     Contributing author: Michael Monscheuer, E-mail: Monscheuer@t-online.de -->"
$	WRITE 1 "<HTML>"
$	WRITE 1 "<HEAD>"
$	WRITE 1 "<TITLE>xmcd: Local Discographies Main Index</TITLE>"
$	WRITE 1 "</HEAD>"
$	WRITE 1 "<BODY BGCOLOR="""" BACKGROUND=""bkgnd.gif"">"
$	WRITE 1 "<DIV ALIGN=""center"">"
$	WRITE 1 "<A HREF=""http://www.amb.org/xmcd/"">"
$	WRITE 1 "<IMG SRC=""xmcdlogo.gif"" ALT=""xmcd"" BORDER=""0""></A>"
$	WRITE 1 "<H3>Local Discographies: Main Index</H3>"
$	WRITE 1 "</DIV>"
$	WRITE 1 "<P>"
$	WRITE 1 "<P>"
$	WRITE 1 "<H4>Local Discography</H4>"
$	WRITE 1 "<P>"
$	WRITE 1 "<UL>"
$	WRITE 1 "<LI>Browse genres:"
$ META_LOOP:	
$	METADIR = F$SEARCH("*.DIR;*",1)
$	IF METADIR .EQS. "" THEN GOTO SUBG_DONE
$	METADIR = F$PARSE(METADIR,,,"NAME")
$	METASTR = "_" + F$EDIT(METADIR,"LOWERCASE")
$ METAEDITLOOP:
$	UPC = F$EDIT(F$EXTRACT(F$LOCATE("_",METASTR)+1,1,METASTR),"UPCASE")
$	METASTR['F$LOCATE("_",METASTR)+1,1] := "''UPC'"
$	METASTR['F$LOCATE("_",METASTR),1] := " "
$	IF F$LOCATE("_",METASTR) .LT. F$LENGTH(METASTR) THEN GOTO METAEDITLOOP
$	METASTR = F$EDIT(METASTR,"TRIM")
$	WRITE 1 "<UL>"
$	WRITE 1 "<LI>''METASTR' ->"
$	WRITE 1 "<UL>"
$	SET DEF [.'METADIR']
$ SUBG_LOOP:
$	SUBGDIR = F$SEARCH("*.DIR;*",3)
$	IF SUBGDIR .EQS. "" 
$	 THEN 
$	  WRITE 1 "</UL>"
$	  WRITE 1 "</UL>"
$	  SET DEF [-]
$	  GOTO META_LOOP
$	ENDIF
$!
$!	Found a subgenre's directory.
$!
$	SUBGDIR = F$PARSE(SUBGDIR,,,"NAME")
$	SUBGSTR = "_" + F$EDIT(SUBGDIR,"LOWERCASE")
$ SUBGEDITLOOP:
$	UPC = F$EDIT(F$EXTRACT(F$LOCATE("_",SUBGSTR)+1,1,SUBGSTR),"UPCASE")
$	SUBGSTR['F$LOCATE("_",SUBGSTR)+1,1] := "''UPC'"
$	SUBGSTR['F$LOCATE("_",SUBGSTR),1] := " "
$	IF F$LOCATE("_",SUBGSTR) .LT. F$LENGTH(SUBGSTR) THEN GOTO SUBGEDITLOOP
$	SUBGSTR = F$EDIT(SUBGSTR,"TRIM")
$	WRITE 1 "<LI><A HREF=""''METADIR'/''SUBGDIR'/index.html"">''SUBGSTR'</A>"
$!
$!	Check whether this subgenre's index file is to be (re-)generated.
$!	If not, search for next subgenre. 
$!
$	IF P1 .NES. ""
$	 THEN
$	  CURDIR = "''METADIR'.''SUBGDIR'"
$	  IF CURDIR .NES. P1 THEN GOTO SUBG_LOOP
$	ENDIF
$	SET DEF [.'SUBGDIR']
$	IF P2 .NES. "RUN_SILENT" THEN WRITE SYS$OUTPUT "%GIX-S-IDXCAT, generating ''METADIR'.''SUBGDIR' category index."
$!
$!	Delete existing subgenre index file and create a new one.
$!
$	IF F$SEARCH("INDEX.HTML") .NES. "" THEN DELETE/NOCONFIRM INDEX.HTML;*
$	'NEXTDIR'_IDX = 0
$	OPEN/WRITE 0 INDEX.HTML
$	WRITE 0 "<!-- xmcd Local Discography index"
$	WRITE 0 "     DO NOT EDIT: Generated by GENIDX.COM"
$	WRITE 0 "     Copyright (C) 1993-2002 Ti Kan"
$	WRITE 0 "     E-mail: xmcd@amb.org URL: http://www.amb.org/xmcd/"
$	WRITE 0 "     Contributing author: Michael Monscheuer, E-mail: Monscheuer@t-online.de -->"
$	WRITE 0 "<HTML>"
$	WRITE 0 "<HEAD>"
$	WRITE 0 "<TITLE>xmcd: Local Discographies index for &quot;''METASTR' -> ''SUBGSTR'&quot;</TITLE>"
$	WRITE 0 "</HEAD>"
$	WRITE 0 "<BODY BGCOLOR="""" BACKGROUND=""/''discogdir'/bkgnd.gif"">"
$	WRITE 0 "<DIV ALIGN=""center"">"
$	WRITE 0 "<A HREF=""http://www.amb.org/xmcd/"">"
$	WRITE 0 "<IMG SRC=""/''discogdir'/xmcdlogo.gif"" ALT=""xmcd"" BORDER=""0""></A>"
$	WRITE 0 "<H3>Local Discography: Index for &quot;''METASTR' -> ''SUBGSTR'&quot;</H3>"
$	WRITE 0 "</DIV>"
$	WRITE 0 "<P>"
$	WRITE 0 "<DIV ALIGN=center>"
$!	
$!	Now check out the existance of INDEX.HTML files in the particular
$!	subgenres' subdirectories. Branch depending upon circumstances.
$!	
$ IDX_LOOP:
$	NEXTIDX = F$SEARCH("[.*]INDEX.HTML;0",2)
$	IF NEXTIDX .EQS. "" 
$	 THEN
$	  IF .NOT. 'NEXTDIR'_IDX
$	   THEN
$	    WRITE 0 "<B>No entries found in this category</B>"
$	    WRITE 0 "<P>"
$	   ELSE
$	    WRITE 0 "</TABLE>"
$	    WRITE 0 "<P>"
$	  ENDIF
$	  GOSUB BOTTOM
$	  SET DEFAULT [-]
$	  GOTO SUBG_LOOP
$	ENDIF
$!	
$!	Add each entry found in the subgenres' directories to the subgenre's
$!	INDEX.HTML entry table.
$!	
$	IF 'NEXTDIR'_IDX .EQ. 1 THEN GOTO SKIP_TABLE
$	WRITE 0 "<TABLE CELLSPACING=""0"" CELLPADDING=""2"" BORDER=""1"">"
$	WRITE 0 "<TR>"
$	WRITE 0 "<TD ALIGN=""center"">Disc ID</TD>"
$	WRITE 0 "<TD ALIGN=""center"">Description<BR></TD>"
$	WRITE 0 "</TR>"
$	'NEXTDIR'_IDX = 1
$ SKIP_TABLE:
$!	
$!	Search CD's INDEX.HTML for title information and extract 
$!	it to the category's INDEX.HMTL entry table.
$!	
$	NEXTIDD = F$PARSE(NEXTIDX,,,"DIRECTORY")
$	DISCID = F$EXTRACT(F$LENGTH(NEXTIDD)-9,8,NEXTIDD)
$	SEARCH/EXACT/OUT=TMP.TMP [.'DISCID']INDEX.HTML "<!-- tItLe: "
$	OPEN/READ 10 TMP.TMP
$	READ 10 LINE
$	CLOSE 10
$	DELETE/NOCONFIRM TMP.TMP;0
$	CDTITLE = LINE - "<!-- tItLe: " - " -->"
$
$	WRITE 0 "<TR>"
$	WRITE 0 "<TD ALIGN=""left"">"
$	WRITE 0 "<A HREF=""/''DISCOGDIR'/''METADIR'/''SUBGDIR'/''DISCID'/index.html"">''DISCID'</A>"
$	WRITE 0 "</TD>"
$	WRITE 0 "<TD ALIGN=""left"">"
$	WRITE 0 "''CDTITLE'"
$	WRITE 0 "<BR></TD>"
$	WRITE 0 "</TR>"
$	GOTO IDX_LOOP
$ BOTTOM:
$!	
$!	Add bottom part to the particular category's INDEX.HTML
$!	
$	WRITE 0 "</TABLE>"
$	WRITE 0 "</DIV>"
$	WRITE 0 "<P>"
$	WRITE 0 "<H4>Local Discography</H4>"
$	WRITE 0 "<P>"
$	WRITE 0 "<UL>"
$	WRITE 0 "<LI><A HREF=""/''discogdir'/index.html"">Main Index</A>"
$	WRITE 0 "<LI><A HREF=""/''discogdir'/discog.html"">How to use Local Discography</A></LI>"
$	WRITE 0 "</UL>"
$	WRITE 0 "<P>"
$	WRITE 0 "<HR>"
$	WRITE 0 "<SMALL>Generated on ''F$TIME()' by ''IDENT'</SMALL>"
$	WRITE 0 "</BODY>"
$	WRITE 0 "</HTML>"
$	CLOSE 0
$	RETURN
$ SUBG_DONE:
$!	
$!	Finally add bottom part to the main index file.
$!	
$	WRITE 1 "<P>"
$	WRITE 1 "<LI><A HREF=""discog.html"">How to use Local Discography</A></LI>"
$	WRITE 1 "</UL>"
$	WRITE 1 "<P>"
$	WRITE 1 "<H4>Man pages</H4>"
$	WRITE 1 "<UL>"
$	WRITE 1 "<LI><A HREF=""xmcd.html"">xmcd man page</A></LI>"
$	WRITE 1 "</UL>"
$	WRITE 1 "<HR>"
$	WRITE 1 "<SMALL>Generated on ''F$TIME()' by ''IDENT'</SMALL>"
$	WRITE 1 "</BODY>"
$	WRITE 1 "</HTML>"
$	CLOSE 1
$	SET DEFAULT 'ENVI'
$	
$!	
$!	Index processing and generation complete. 
