#!/bin/sh
#
# @(#)genidx.sh	6.41 02/01/06
#
# Generate xmcd Local Discography main index and per-genre index files
# This is run automatically by xmcd/cda as needed, or can be manually
# invoked.
#
#    xmcd  - Motif(tm) CD Audio Player
#    cda   - Command-line CD Audio Player
#    libdi - CD Audio Player Device Interface Library
#
#    Copyright (C) 1993-2002  Ti Kan
#    E-mail: xmcd@amb.org
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
PATH=/bin:/usr/bin:/usr/local/bin; export PATH

# Modify these to suit your local configuration
XMCDLIB=/usr/lib/X11/xmcd
DISCOGDIR=$XMCDLIB/discog
FILE_MODE=666

XMCD_EMAIL=xmcd@amb.org
XMCD_URL=http://www.amb.org/xmcd/
TMPFILE=/tmp/_gilist.$$


header_out()
{
	dhome="$1"
	genre="$2"

	echo "<!-- xmcd Local Discography index"
	echo "     DO NOT EDIT: Generated by @(#)genidx.sh	6.41 02/01/06"
	echo "     Copyright (C) 1993-2002 Ti Kan"
	echo "     E-mail: $XMCD_EMAIL URL: $XMCD_URL -->"
	echo "<HTML>"
	echo "<HEAD>"
	if [ $genre = "main" ]
	then
	    echo "<TITLE>xmcd: Local Discographies Main Index</TITLE>"
	else
	    echo "<TITLE>xmcd: Local Discographies index for &quot;${gname}&quot;</TITLE>"
	fi
	echo "</HEAD>"

	echo "<BODY BGCOLOR=\"$FFFFFF\" BACKGROUND=\"${dhome}bkgnd.gif\">"
	echo "<DIV ALIGN=\"center\">"

	echo "<A HREF=\"$XMCD_URL\">"
	echo "<IMG SRC=\"${dhome}xmcdlogo.gif\" ALT=\"xmcd\" BORDER=\"0\"></A>"
	if [ $genre = "main" ]
	then
	    echo "<H3>Local Discographies: Main Index</H3>"
	else
	    echo "<H3>Local Discographies: Index for &quot;${gname}&quot;</H3>"
	fi
	echo "</DIV>"
	echo "<P>"
}

genre_out()
{
	dhome="$1"
	echo "<P>"
	echo "<H4>Local Discography</H4>"
	echo "<P>"

	echo "<UL>"

	if [ -n "$dhome" ]
	then
		echo "<LI><A HREF=\"${dhome}index.html\">Main index</A>"
	else
		echo "<LI>Browse genres:"

		echo "<UL>"
		prev_pri=""
		for k in $genredirs
		do
			pri_genre=`dirname $k`
			sec_genre=`basename $k | sed 's/_/ /'`

			if [ -z "$prev_pri" ]
			then
				echo "<LI>$pri_genre ->"
				echo "<UL>"
			elif [ "$prev_pri" != "$pri_genre" ]
			then
				echo "</UL>"
				echo "</UL>"
				echo "<UL>"
				echo "<LI>$pri_genre ->"
				echo "<UL>"
			fi

			echo "<LI><A HREF=\"${dhome}$k/index.html\">$sec_genre</A>"
			prev_pri="$pri_genre"
		done
		echo "</UL>"

		echo "</UL>"
	fi

	echo "<LI><A HREF=\"${dhome}discog.html\">How to use Local Discography</A></LI>"
	echo "</UL>"
	echo "<P>"
	if [ -z "$dhome" ]
	then
		echo "<H4>Man pages</H4>"
		echo "<UL>"
		echo "<LI><A HREF=\"xmcd.html\">xmcd man page</A></LI>"
		echo "<LI><A HREF=\"cda.html\">cda man page</A></LI>"
		echo "</UL>"
	fi
}

tail_out()
{
	echo "<HR>"
	echo "<SMALL>Generated on `date` by @(#)genidx.sh	6.41 02/01/06</SMALL>"
	echo "</BODY>"
	echo "</HTML>"
}


#
# Main starts here
#

if [ $# -gt 1 ]
then
	echo "Usage: $0 [genredir]" >&2
fi

echo ""
echo "Generating xmcd Local Discography index files..."

if [ ! -d $DISCOGDIR ]
then
	echo "	Error: cannot process $DISCOGDIR" >&2
	exit 1
fi

cd $DISCOGDIR

# Determine genre directories
if [ $# -eq 1 ]
then
    genredirs=$1
else
    genredirs=`find */* -type d \
	! -name '[0-9,a-f][0-9,a-f][0-9,a-f]??[0-9,a-f][0-9,a-f][0-9,a-f]' \
	-print 2>/dev/null`
fi

if [ -z "$genredirs" ]
then
	echo "	No genres to process" >&2
	exit 1
fi

for i in $genredirs
do
	if [ ! -d "$i" ]
	then
		echo "	$DISCOGDIR/$i does not exist: skipping." >&2
		continue
	fi

	echo "	Scanning $i"
	dhome="../../"

	rm -f $i/index.html
	(
		cd $i
		gname=`echo $i | sed -e 's/_/ /g' -e 's/\// -> /g'`

		header_out "$dhome" "$i"

		for j in *
		do
			if [ $j = index.html -o ! -r $j/index.html ]
			then
				continue
			fi
			if [ `expr $j : '[0-9,a-f][0-9,a-f][0-9,a-f][0-9,a-f][0-9,a-f][0-9,a-f][0-9,a-f][0-9,a-f]'` -ne 8 ]
			then
				continue
			fi
			dtitle=`grep "^<!-- tItLe:" $j/index.html | \
			sed -e 's/<!-- tItLe: //' -e 's/ -->//'`
			echo "$j $dtitle"
		done | sort -f +1 | awk '{ print $1 }' >$TMPFILE 2>&1

		echo "<DIV ALIGN="center">"
		first=1
		for j in `cat $TMPFILE`
		do
			if [ ! -r $j/index.html ]
			then
				continue
			fi
			if [ $first = 1 ]
			then
				first=0
				echo "<TABLE CELLSPACING=\"0\" CELLPADDING=\"2\" BORDER=\"1\""
				echo "<TR>"
				echo "<TD ALIGN=\"center\">Disc ID</TD>"
				echo "<TD ALIGN=\"center\">Description<BR></TD>"
				echo "</TR>"
			fi

			echo "<TR>"
			echo "<TD ALIGN=\"left\">"
			echo "<A HREF=\"$j/index.html\">$j</A>"
			echo "</TD>"
			echo "<TD ALIGN=\"left\">"

			grep "^<!-- tItLe:" $j/index.html | \
			sed -e 's/<!-- tItLe: //' -e 's/ -->//'

			echo "<BR></TD>"
			echo "</TR>"
		done
		rm -f $TMPFILE

		if [ $first = 1 ]
		then
			echo "<B>No albums found in this genre</B>"
		else
			echo "</TABLE>"
		fi
		echo "</DIV>"

		genre_out "$dhome"
		tail_out
	) >$i/index.html 2>/dev/null

	chmod $FILE_MODE $i/index.html 2>/dev/null
done

genredirs=`find */* -type d \
	! -name '[0-9,a-f][0-9,a-f][0-9,a-f]??[0-9,a-f][0-9,a-f][0-9,a-f]' \
	-print 2>/dev/null`

# Generate main index page
echo "	Generating Main index"
rm -f index.html
(
	header_out "" "main"
	genre_out ""
	tail_out
) >index.html 2>/dev/null
chmod $FILE_MODE index.html 2>/dev/null

exit 0


