/*  XMMS - Cross-platform multimedia player
 *  Copyright (C) 1998-2000  Peter Alm, Mikael Alm, Olle Hallnas, Thomas Nilsson and 4Front Technologies
 *  Copyright (C) 2000 Hvard Kvlen <havardk@xmms.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include "xmms.h"
#include "xmms_logo.xpm"

/*
 * The different sections are kept in alphabetical order
 */

static const gchar *credit_text[] =
{N_("Main Programming:") ,
	N_("Peter Alm"),
	NULL,
 N_("Additional Programming:"),
/* for languages that can't display 'aring' () replace it with "aa" */
	N_("Hvard Kvlen"),
	N_("Derrik Pates"),
	NULL,
 N_("With Additional Help:"),
	N_("Sean Atkinson"),
	N_("James M. Cape"),
	N_("Anders Carlsson (effect plugins)"),
	N_("Chun-Chung Chen (xfont patch)"),
	N_("Tim Ferguson (joystick plugin)"),
	N_("Ben Gertzfield"),
	N_("Vesa Halttunen"),
	N_("Logan Hanks"),
	N_("Eric L. Hernes (FreeBSD patches)"),
	N_("Ville Herva"),
        N_("Michael Hipp and others (MPG123 engine)"),
/* for languages that can't display 'adiaeresis' () replace it with "ae" */
	N_("Olle Hllns (compiling fixes)"),
	N_("Osamu Kayasono (3DNow!)"),
	N_("Lyle B Kempler"),
	N_("J. Nick Koston (MikMod plugin)"),
	N_("Aaron Lehmann"),
	N_("Johan Levin (echo + stereo plugin)"),
	N_("Eric Lindvall"),
	N_("Colin Marquardt"),
	N_("Willem Monsuwe"),
	N_("Pablo Saratxaga (i18n)"),
	N_("Carl van Schaik (pro logic plugin)"),
/* for languages that can't display 'odiaeresis' () replace it with "oe" */
	N_("Jrg Schuler"),
	N_("Charles Sielski (irman plugin)"),
	N_("Espen Skoglund"),
	N_("Kimura Takuhiro (3DNow!)"),
	N_("Zinx Verituse"),
	N_("Ryan Weaver (RedHat RPMs among other things)"),
	N_("Chris Wilson"),
	N_("Dave Yearke"),
	N_("Stephan K. Zitz"),
        N_("David Jacoby"),
	NULL,
 N_("Homepage and Graphics:"),
	N_("Thomas Nilsson"),
	NULL,
 N_("Support and Docs:"),
/* for languages that can't display 'adiaeresis' () replace it with "ae" */
	N_("Olle Hllns"),
	NULL, NULL};


void show_about_window(void)
{
	static GtkWidget *about_window = NULL;
	static GdkPixmap *xmms_logo_pmap = NULL, *xmms_logo_mask = NULL;

	GtkWidget *about_vbox, *about_notebook;
	GtkWidget *about_credits_vbox;
	GtkWidget *about_credits_logo_box, *about_credits_logo_frame;
	GtkWidget *about_credits_logo;
	GtkWidget *bbox, *close_btn;
	GtkWidget *label, *clist, *scrollwin;
	gchar *text;
	gint i;

	if (about_window)
		return;
	
	about_window = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_title(GTK_WINDOW(about_window), _("About XMMS"));
	gtk_window_set_policy(GTK_WINDOW(about_window), FALSE, TRUE, FALSE);
	gtk_container_set_border_width(GTK_CONTAINER(about_window), 10);
	gtk_signal_connect(GTK_OBJECT(about_window), "destroy",
			   GTK_SIGNAL_FUNC(gtk_widget_destroyed), &about_window);
	gtk_widget_realize(about_window);
	
	about_vbox = gtk_vbox_new(FALSE, 10);
	gtk_container_add(GTK_CONTAINER(about_window), about_vbox);
	
	about_notebook = gtk_notebook_new();
	gtk_box_pack_start(GTK_BOX(about_vbox), about_notebook, TRUE, TRUE, 0);
	
	about_credits_vbox = gtk_vbox_new(FALSE, 5);
	gtk_container_set_border_width(GTK_CONTAINER(about_credits_vbox), 10);
	
	if (!xmms_logo_pmap)
		xmms_logo_pmap = gdk_pixmap_create_from_xpm_d(about_window->window,
							      &xmms_logo_mask, NULL, xmms_logo);
	
	about_credits_logo_box = gtk_hbox_new(TRUE, 0);
	gtk_box_pack_start(GTK_BOX(about_credits_vbox), about_credits_logo_box, FALSE, FALSE, 0);
	
	about_credits_logo_frame = gtk_frame_new(NULL);
	gtk_frame_set_shadow_type(GTK_FRAME(about_credits_logo_frame), GTK_SHADOW_OUT);
	gtk_box_pack_start(GTK_BOX(about_credits_logo_box), about_credits_logo_frame, FALSE, FALSE, 0);
	
	about_credits_logo = gtk_pixmap_new(xmms_logo_pmap, xmms_logo_mask);
	gtk_container_add(GTK_CONTAINER(about_credits_logo_frame), about_credits_logo);
	
	text = g_strdup_printf(_("XMMS %s - Cross platform multimedia player"), VERSION);
	label = gtk_label_new(text);
	g_free(text);
	
	gtk_box_pack_start(GTK_BOX(about_credits_vbox), label, FALSE, FALSE, 0);
	
	label = gtk_label_new(_("Copyright (C) 1997-2000 4front Technologies"));
	gtk_box_pack_start(GTK_BOX(about_credits_vbox), label, FALSE, FALSE, 0);
	
	clist = gtk_clist_new(2);
	i = 0;
	while (credit_text[i])
	{
		gchar *temp[2];
		guint row;
		
		temp[0] = gettext(credit_text[i++]);
		temp[1] = gettext(credit_text[i++]);
		row = gtk_clist_append(GTK_CLIST(clist), temp);
		gtk_clist_set_selectable(GTK_CLIST(clist), row, FALSE);
		temp[0] = "";
		while (credit_text[i])
		{
			temp[1] = gettext(credit_text[i++]);
			row = gtk_clist_append(GTK_CLIST(clist), temp);
			gtk_clist_set_selectable(GTK_CLIST(clist), row, FALSE);
		}
		i++;
		if (credit_text[i])
		{
			temp[1] = "";
			row = gtk_clist_append(GTK_CLIST(clist), temp);
			gtk_clist_set_selectable(GTK_CLIST(clist), row, FALSE);
		}
	}
	gtk_clist_columns_autosize(GTK_CLIST(clist));
	gtk_clist_set_column_justification(GTK_CLIST(clist), 0, GTK_JUSTIFY_RIGHT);
	
	scrollwin = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrollwin),
				       GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);
	gtk_container_add(GTK_CONTAINER(scrollwin), clist);
	gtk_box_pack_start(GTK_BOX(about_credits_vbox), scrollwin, TRUE, TRUE, 0);
	gtk_widget_set_usize(scrollwin, -1, 120);
		
	gtk_notebook_append_page(GTK_NOTEBOOK(about_notebook), about_credits_vbox,
				 gtk_label_new(_("Credits")));

	bbox = gtk_hbutton_box_new();
	gtk_button_box_set_layout(GTK_BUTTON_BOX(bbox), GTK_BUTTONBOX_END);
	gtk_button_box_set_spacing(GTK_BUTTON_BOX(bbox), 5);
	gtk_box_pack_start(GTK_BOX(about_vbox), bbox, FALSE, FALSE, 0);

	close_btn = gtk_button_new_with_label(_("Close"));
	gtk_signal_connect_object(GTK_OBJECT(close_btn), "clicked",
				  GTK_SIGNAL_FUNC(gtk_widget_destroy),
				  GTK_OBJECT(about_window));
	GTK_WIDGET_SET_FLAGS(close_btn, GTK_CAN_DEFAULT);
	gtk_box_pack_start(GTK_BOX(bbox), close_btn, TRUE, TRUE, 0);
	gtk_widget_grab_default(close_btn);

	gtk_widget_show_all(about_window);
}
