/*  XMMS - Cross-platform multimedia player
 *  Copyright (C) 1998-2000  Peter Alm, Mikael Alm, Olle Hallnas, Thomas Nilsson and 4Front Technologies
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include "xmms.h"

#ifndef fixed
#define fixed short
#endif

struct EffectPluginData *ep_data;

EffectPlugin *get_current_effect_plugin(void)
{
	return ep_data->current_effect_plugin;
}

void effect_about(int i)
{
	EffectPlugin *effect = (EffectPlugin *) g_list_nth(ep_data->effect_list, i)->data;
	if (effect && effect->about)
		effect->about();
}

void effect_configure(int i)
{
	EffectPlugin *effect = (EffectPlugin *) g_list_nth(ep_data->effect_list, i)->data;
	if (effect && effect->configure)
		effect->configure();
}

void set_current_effect_plugin(int i)
{
	ep_data->current_effect_plugin = (EffectPlugin *) g_list_nth(ep_data->effect_list, i)->data;
}

GList *get_effect_list(void)
{
	return ep_data->effect_list;
}

int effects_enabled(void)
{
	return cfg.use_eplugins;
}
