/* -
 * Copyright (c) 2002, Ramsey G. Brenner <rgbrenner@myrealbox.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Redistributions of products derived from this software must obtain
 *    the specific prior written permission of the author.
 * 4. Neither the name of the author nor the names of its contributors may
 *    be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */


extern char *prog_name;

typedef unsigned char bgen_t;

FILE  *urandom;
enum {
    URANDOM,
    SSL
} bgen_type = SSL;

/* Generate a single byte */
int
genbyte(unsigned char *byte)
{
    enum {
      OK,
      FAILURE
    };

    if(bgen_type == SSL) {
      if(RAND_bytes(byte, 1) <= 0) {
        return(FAILURE);
      }
    } else if(bgen_type == URANDOM) {
      if(!fread(byte, sizeof(bgen_t), 1, urandom)) {
        return(FAILURE);
      }
    }
    return(OK);
}

/* Generate a key <length> bytes long */
int
genkey(FILE *key, int length)
{
    int     i;
    bgen_t  byte;
    enum {
      OK,
      GEN_ERR,
      WR_ERR,
      OP_ERR
    };

    if(bgen_type == URANDOM) {
      if((urandom = fopen("/dev/urandom", "r")) == NULL) {
        return(OP_ERR);
      }
    }

    for(i = 0; i < length; i++) {
      if(genbyte(&byte)) {
        return(GEN_ERR);
      }
      if(!fwrite(&byte, sizeof(bgen_t), 1, key)) {
        return(WR_ERR);
      }
    }

    if(bgen_type == URANDOM) {
      fclose(urandom);
    }
    return(OK);
}

/* XOR input files **in_fp and output to *out_fp */
void
XORFiles(FILE **in_fp, FILE *out_fp, int size)
{
    int             i,
                    nbytes;
    unsigned char   byte,
                    in_byte,
                    out_byte;

    for(i = 1, nbytes = 0;; i++) {
      /* If we're out of files,
         reset i and write in_byte */
      if(in_fp[i - 1] == NULL) {
        i = 0;
        /* Write byte */
        if(!fwrite(&out_byte, sizeof(out_byte), 1, out_fp)) {
          fprintf(stderr, "%s: Error writing byte!\n",
            prog_name);
          exit(EXIT_FAILURE);
        }
        nbytes++;

        /* break if user specified a size and it has been reached */
        if(nbytes >= size && size != -1) {
          break;
        }
        continue;
      }

      /* Read byte */
      if(!fread(&in_byte, sizeof(in_byte), 1, in_fp[i - 1])) {
        if(feof(in_fp[i - 1])) {
          break;
        } else {
          fprintf(stderr, "%s: Error reading byte!\n",
            prog_name);
          exit(EXIT_FAILURE);
        }
      }

      /* XOR byte */
      if(i != 1) {
        out_byte ^= in_byte;
      } else {
        out_byte = in_byte;
      }
    }

    /* If size is larger than the current file size,
       append random data to file */
    if(size != -1) {
      for(; nbytes < size; nbytes++) {
        /* Gen byte */
        if(genbyte(&byte)) {
          fprintf(stderr, "%s: Error generating byte!\n",
            prog_name);
          exit(EXIT_FAILURE);
        }

        /* Write byte */
        if(!fwrite(&out_byte, sizeof(out_byte), 1, out_fp)) {
          fprintf(stderr, "%s: Error writing byte!\n",
            prog_name);
          exit(EXIT_FAILURE);
        }
      }
    }
    return;
}
