/* -
 * Copyright (c) 2002, Ramsey G. Brenner <rgbrenner@myrealbox.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Redistributions of products derived from this software must obtain
 *    the specific prior written permission of the author.
 * 4. Neither the name of the author nor the names of its contributors may
 *    be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

extern char *prog_name;

#if 0
int    memcnt = 0;
void **memstk = NULL;

/* malloc with memory handling/tracking */
/* Currently it only makes sure everything
   gets free()'d on exit */
void *
Malloc(size_t size)
{
    /* Check if memstk has been used */
    if(memcnt == 0) {
      /* Init memstk */
      memstk = Malloc_(1);
      memstk[0] = NULL;
      memcnt++;

      /* Register call for FreeAll() at exit */
      AtExit(FreeAll);
    }

    /* Malloc space in memstk for new data */
    memstk = Realloc(memstk, memcnt + 1);
    memstk[memcnt] = NULL;
    memstk[memcnt - 1] = Malloc_(size);
    memcnt++;

    /* Return space */
    return(memstk[memcnt - 1]);
}

/* free() with memstk handling */
void
Free(void *ptr)
{
    int    i,
           j = 0;
    void **tmpstk;
    enum {
      F,
      T
    } in_memstk = F;

    for(i = 0; i < memcnt; i++) {
      if(memstk[i] == ptr) {
        in_memstk = T;
        break;
      }
    }

    if(in_memstk == T) {
      memcnt--;

      /* Reset memstk if this is its last entry */
      if(memcnt == 1) {
        free(memstk);
        memstk = NULL;
        memstk--;
      } else {
        /* Create a new memstk */
        tmpstk = Malloc(memcnt);
        bzero(tmpstk, memcnt);

        /* Copy old memstk to tmpstk (except ptr) */
        for(i = 0; i < memcnt; i++) {
          if(memstk[i] == ptr) {
           j = 1;
          }
          tmpstk[i - j] = memstk[i];
        }

        /* Replace memstk with tmpstk */
        free(memstk);
        memstk = tmpstk;
      }
    }

    /* Free ptr */
    free(ptr);
}

/* Free all memory */
void
FreeAll(void)
{
    int   i;

    if(memstk != NULL) {
      for(i = 0; memstk[i] != NULL; i++) {
        free(memstk[i]);
      }
      free(memstk);
    }
    memstk = NULL;
}
#else
#define Free free
#endif

/* malloc() */
void *
Malloc(size_t size)
{
    void  *tmp;

    if((tmp = malloc(size)) == NULL) {
      perror(prog_name);
      exit(EXIT_FAILURE);
    }
    return(tmp);
}

/* realloc() */
void *
Realloc(void *ptr, size_t size)
{
    void *tmp;

    if((tmp = realloc(ptr, size)) == NULL) {
      perror(prog_name);
      exit(EXIT_FAILURE);
    }
    return(tmp);
}
