/*
   Copyright (C) 1999 Rocky Bernstein
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
static char process_window_help[] =
"When a process name is selected on the process-tree canvas, a dialog\n"
"box for that process pops up if it is not already open. If it is\n"
"already open and a different process is selected underneath, the\n"
"process information changes. In order to show the which process is\n"
"selected on process-tree canvas, the process name changes color to the\n"
"color specified by the \"selected\" resource.\n"
"\n"
"The Process Dialog Box lists information about the process. Also it\n"
"can be used to set the priority of the process or process group and\n"
"can be used to send a signal to the process or process group.\n"
"\n"
"The top part of the dialog box gives information gathered from the\n"
"\"ps\" command. Since a command invocation may be rather long, this is\n"
"listed on a separate line.\n"
"\n"
"Below that to the left side is scrollable list of signals which can be\n"
"sent to the process. This list is automatically generated when the\n"
"program was compiled via the program \"makesig.pl\". The list of\n"
"signals is in sorted order, but the most common signals are listed at\n"
"the top according to my preference. If the \"Quick Kill\" toggle button\n"
"had been depressed, the signal selected in the \"Set Quick Kill Signal Dialog\" \n"
"is selected. Otherwise \"NO ACTION\" will be selected and you\n"
"will have to select a signal if you want to send a signal to a\n"
"process.\n"
"\n"
"To the right of the scrollable list of signals is a slider which can\n"
"be used to set the process priority. The initial value is the value at\n"
"the time for that process at the time the process was selected.\n"
"\n"
"There is a notion in Unix called a process group which is a group of\n"
"processes that are usually related in some way; perhaps they were\n"
"spawned from a common parent. Instead of sending a kill signal to a\n"
"specific process, the signal can be sent to the set process of\n"
"processes in the process group. Likewise instead of setting the\n"
"priority for a single process it can be set for the process group.\n"
"The process group toggle button in the process dialog is used to\n"
"indicate that a signal or priority should be applied to the process\n"
"group rather than the process that is selected.\n"
"\n"
"Note that in order to for a kill signal or a change in priority to\n"
"take effect, you may need sufficient permission to do so. This is no\n"
"different than say if you were to run \"kill\" or \"nice\" from a shell.\n"
"\n"
"If there is a problem performing the action requested (and the program\n"
"catches you), the old value is kept.\n"
"\n"
;
