/* This file is part of the Project Athena Zephyr Notification System.
 * It is one of the source files comprising zwgc, the Zephyr WindowGram
 * client.
 *
 *      Created by:     Marc Horowitz <marc@athena.mit.edu>
 *
 *      Copyright (c) 1989 by the Massachusetts Institute of Technology.
 *      For copying and distribution information, see the file
 *      "mit-copyright.h".
 */

#include <sysdep.h>

RCSID("$Id: regexp.c,v 1.12 2000/07/06 23:36:18 assar Exp $");

#ifdef SOLARIS
#include <libgen.h>
#endif

#ifdef HAVE_REGEX_H
#include <regex.h>
#define REGEX regex_t
#elif defined(HAVE_REGEXP_H)
#include <regexp.h>
#define REGEX regexp
#ifndef REG_NOSUB
#define REG_NOSUB 0
#endif
#ifndef REG_NOMATCH
#define REG_NOMATCH 0
#endif
#else /* !HAVE_REGEX_H && !HAVE_REGEXP_H */
#error "no regep"
#endif
#include "regexp_i.h"


#if defined(HAVE_REGCOMP)

int
ed_regexp_match_p(string test_string, string pattern)
{
    REGEX RE;
    int retval;
    char errbuf[512];

    retval = regcomp(&RE, pattern, REG_NOSUB);
    if (retval != 0) {
	regerror(retval, &RE, errbuf, sizeof(errbuf));
	fprintf(stderr,"%s in regcomp %s\n",errbuf,pattern);
	return(0);
    }
    retval = regexec(&RE, test_string, 0, NULL, 0);
    if (retval != 0 && retval != REG_NOMATCH) {
	regerror(retval, &RE, errbuf, sizeof(errbuf));
	fprintf(stderr,"%s in regexec %s\n",errbuf,pattern);
	regfree(&RE);
	return(0);
    }
    regfree(&RE);
    return(retval == 0 ? 1 : 0);
}

#else  /* !HAVE_REGCOMP */

int
ed_regexp_match_p(string test_string, string pattern)
{
    char *comp_retval;
    int exec_retval;

    if (comp_retval = re_comp(pattern)) {
       fprintf(stderr,"%s in regex %s\n",comp_retval,pattern);
       return(0);
    }
    if ((exec_retval=re_exec(test_string)) == -1) {
       fprintf(stderr,"Internal error in re_exec()");
       return(0);
    }

    return(exec_retval);
}
#endif /* !HAVE_REGCOMP */
