/* This file is part of the Project Athena Zephyr Notification System.
 * It is one of the source files comprising zwgc, the Zephyr WindowGram
 * client.
 *
 *      Created by:     Marc Horowitz <marc@athena.mit.edu>
 *
 *      $Id: text_operations.h,v 1.6 2000/07/07 23:40:00 assar Exp $
 *
 *      Copyright (c) 1989 by the Massachusetts Institute of Technology.
 *      For copying and distribution information, see the file
 *      "mit-copyright.h".
 */


#include <zephyr/mit-copyright.h>

#ifndef text_operations_MODULE
#define text_operations_MODULE

#include "character_class.h"

extern string protect(string str);
string verbatim(string str, int bracketsonly);
extern string stylestrip(string str);
extern string lany(string *text_ptr, string str);
extern string lbreak(string *text_ptr, const character_class set);
extern string lspan(string *text_ptr, const character_class set);
extern string rany(string *text_ptr, string str);
extern string rbreak(string *text_ptr, const character_class set);
extern string rspan(string *text_ptr, const character_class set);

#endif
