/* This file is part of the Project Athena Zephyr Notification System.
 * It contains source for the ZFormatNoticeList function.
 *
 *	Created by:	Robert French
 *
 *	Copyright (c) 1987,1991 by the Massachusetts Institute of Technology.
 *	For copying and distribution information, see the file
 *	"mit-copyright.h". 
 */

#include <internal.h>

RCSID("$Id: ZFmtList.c,v 1.5 2000/08/14 12:49:33 lha Exp $");

Code_t
ZFormatNoticeList(ZNotice_t *notice, 
		  char **list, 
		  int nitems, 
		  char **buffer, 
		  int *ret_len, 
		  Z_AuthProc cert_routine)
{
    char header[Z_MAXHEADERLEN];
    int hdrlen, size, i;
    char *ptr;
    Code_t retval;

    retval = Z_FormatHeader(notice, header, sizeof(header),
			    &hdrlen, cert_routine);
    if (retval != ZERR_NONE)
	return (retval);

    size = 0;
    for (i=0;i<nitems;i++)
	size += strlen(list[i])+1;

    *ret_len = hdrlen+size;

    *buffer = malloc(*ret_len);
    if (*buffer == NULL)
	return ENOMEM;

    memcpy(*buffer, header, hdrlen);

    ptr = *buffer + hdrlen;

    for (;nitems;nitems--, list++) {
	i = strlen(*list)+1;
	memcpy(ptr, *list, i);
	ptr += i;
    }

    return (ZERR_NONE);
}
