#include <sysdep.h>
#include <zephyr/zephyr.h>
#include <com_err.h>

int
main(int argc, char *argv[])
{
	int retval;
	short wgport;
	int nrealms, i;

	if ((retval = ZInitialize()) != ZERR_NONE) {
	  com_err(argv[0],retval,"while initializing");
	  exit (1);
	}

 	if ((wgport = ZGetWGPort()) == -1) {
	  com_err(argv[0],errno,"while finding WindowGram port");
	  exit (1);
	} 
	
	retval = ZGetRealmCount(&nrealms);
	if (retval) {
	  com_err(argv[0],retval,"ZGetRealmCount");
	  exit (1);
	}

	for (i = 0; i < nrealms; ++i) {
	    ZSubscription_t subs;
	    int nsubs, one;
	    char *realm;

	    retval = ZGetRealmName(i, &realm);
	    if (retval) {
		com_err(argv[0],retval,"ZGetRealmName");
		exit (1);
	    }

	    retval = ZRetrieveSubscriptions(realm, (u_short)wgport,&nsubs);

	    if (retval && retval != ZERR_TOOMANYSUBS) {
		com_err(argv[0],retval,"while finding subscriptions");
		exit (1);
	    }

	    if (nsubs < 1)
		continue;

	    one = 1;

	    if ((retval = ZGetSubscriptions(&subs,&one)) != ZERR_NONE) {
		com_err(argv[0],retval,"while getting subscription");
		exit (1);
	    }

	    retval = ZSubscribeTo(realm, &subs,1,(u_short)wgport);
	
	    if (retval != ZERR_NONE) {
		com_err(argv[0],retval,"while subscribing");
		exit (1);
	    }

	}

	exit (0);
} 
