/*
 * Copyright (c) 2000 Kungliga Tekniska Hgskolan
 * (Royal Institute of Technology, Stockholm, Sweden).
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * 3. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <internal.h>

RCSID("$Id: ZExpnRlm.c,v 1.9 2000/06/07 00:30:08 assar Exp $");

#ifndef KRB_CONFFILE
#define KRB_CONFFILE "/etc/krb.conf"
#endif

/*
 * Expand the realm in `realm', returning the expanded result in
 * `ret_realm' (or maximum size `sz') and by return value.
 */

char *
ZExpandRealm (const char *realm, char *ret_realm, size_t sz)
{
    struct hostent *he;
#ifdef HAVE_KRB4
    char str[BUFSIZ];
    FILE *f;
    int rsz;

    rsz = strlen (realm);

    f = fopen (KRB_CONFFILE, "r");
    if (f) {
	while (fgets (str, sizeof(str), f)) {
	    char *c;

	    if (str[strlen(str) - 1] == '\n')
		str[strlen(str) - 1] = '\0';
	    
	    c = strpbrk(str, " \t");
	    if (c)
		*c = '\0';
	    
	    if (str[0] == '\0')
		continue;
	    
	    if (strncasecmp (str, realm, rsz) == 0) {
		strlcpy (ret_realm, str, sz);
		strupr (ret_realm);
		fclose(f);
		return ret_realm;
	    }
	}
	fclose (f);
    } 
#endif
    he = gethostbyname (realm);
    if (he && he->h_name) {
	strlcpy (ret_realm, he->h_name, sz);
    } else {
	strlcpy (ret_realm, realm, sz);
    }
    strupr (ret_realm);
    return ret_realm;
}
