/* This file is part of the Project Athena Zephyr Notification System.
 * It contains source for the ZGetRealmCount and ZGetRealmName functions.
 *
 *	Created by:	Marc Horowitz
 *
 *	Copyright (c) 1987, 1991 by the Massachusetts Institute of Technology.
 *	For copying and distribution information, see the file
 *	"mit-copyright.h". 
 */

#include <internal.h>

RCSID("$Id: ZRealmCnt.c,v 1.3 2000/02/18 12:19:16 lha Exp $");

Code_t
ZGetRealmCount(int *pcnt)
{
   *pcnt = __nrealms;

   return(ZERR_NONE);
}

Code_t
ZGetRealmName(int idx, char **name)
{
   if ((idx < 0) || (idx >= __nrealms))
      return(EINVAL);

   /* return the default realm first.  when the default realm would have
      been return in the order, return the first realm. */

   if (idx == 0)
      *name = __realm_list[__default_realm].realm_config.realm;
   else if (idx == __default_realm) 
      *name = __realm_list[0].realm_config.realm;
   else
      *name = __realm_list[idx].realm_config.realm;

   return(ZERR_NONE);
}
