/* This file is part of the Project Athena Zephyr Notification System.
 * It contains code for the "zpopnotify" command.
 *
 *	Created by:	Robert French
 *
 *	$Source: /afs/stacken.kth.se/src/SourceRepository/stacken-zephyr/clients/zcomsat/zLPRng.c,v $
 *	$Author: lha $
 *
 *	Copyright (c) 1987,1988 by the Massachusetts Institute of Technology.
 *	For copying and distribution information, see the file
 *	"mit-copyright.h". 
 */


#include <sysdep.h>
#include <zephyr/mit-copyright.h>
#include <zephyr/zephyr.h>
#include <stdio.h>
#include <netdb.h>
#include <string.h>
#include <sys/param.h>			/* for MAXHOSTNAMELEN */
#include <com_err.h>
#include <errno.h>
#include <sys/socket.h>

#ifdef RCSID
RCSID("$Id: zLPRng.c,v 1.3 1999/03/16 23:51:38 lha Exp $");
#endif

#define LPR_CLASS "message"
#define LPR_INSTANCE "personal"

#define LINELEN   512

int
main(int argc, char **argv)
{
    int i, len, retval;
    ZNotice_t notice;
    char *lines[2];
    char buf[BUFSIZ] ;
    char *tmp ;
    struct sockaddr_in peer ;
    int peersize = sizeof(peer) ;
    char rcpt[LINELEN] = "\0";
    char msg[LINELEN] = "\0"; 
    char job[LINELEN] = "\0"; 
    char mysender[LINELEN]; 
    char *ptr;
    int printablep = 0;
   
    openlog("zLPRng", LOG_PID, LOG_DAEMON);
    
    if ((retval = ZInitialize()) != ZERR_NONE) {
	syslog (LOG_NOTICE, "zLPRng: error while starting: %s", error_message(retval)) ;
	closelog() ;
	exit (0);
    } 
    
    alarm(10); /* XXX */
    len = recvfrom(0, buf, sizeof (buf), 0, (struct sockaddr*) &peer, &peersize) ;
    if (len <= 0) {
	syslog (LOG_NOTICE, "zLPRng: error reading lpr msg %s", strerror(errno)) ;
	closelog() ;
	exit (0);
    }

    ptr = buf;
    ptr[len-1] = '\0';
    len--;

    while (len > 0) {
	if (len > 11 && strncmp (ptr, "IDENTIFIER ", 11) == 0) {
	    ptr += 11;
	    len -= 11;
	    i = 0;
	    while (*ptr && len > 0 && *ptr != '@' && i < sizeof(rcpt) - 1) {
		rcpt[i] = *ptr;
		i++;
		ptr++;
		len--;
	    }
	    rcpt[i] = '\0';
	} else if (len > 8 && strncmp (ptr, "STATUS", 6) == 0) {
	    char *end;

	    ptr += 6;
	    len -= 6;
	    
	    end = strstr(ptr, "\n.") ;

	    if (end) {
		if (sizeof(msg)-1 < end-ptr)
		    i = sizeof(msg)-1;
		else
		    i = end-ptr;

		strncpy (msg, ptr, i);
		msg[i] = '\0';

		printablep = 
		    strstr (msg, "finished") != NULL ||
		    strstr (msg, "Load");

	    }
	} else if (len > 11 && strncmp (ptr, "JOBNUMBER ", 10) == 0) {
	    ptr += 10;
	    len -= 10;
	    
	    i = 0;
	    while (*ptr && len > 0 && *ptr != '\n' && i < sizeof(job) - 1) {
		job[i] = *ptr;
		i++;
		ptr++;
		len--;
	    }
	    job[i] = '\0';
	} else {
	    while (*ptr && len > 0 && *ptr != '\n') {
		ptr++;
		len--;
	    }
	}
	if (*ptr == '\n') {
	    ptr++;
	    len--;
	}
    }

    if (!printablep)
	return 0;

    lines[0] = job;
    lines[1] = msg;
        
    memset((char *)&notice, 0, sizeof(notice));
    notice.z_kind = UNSAFE;
    notice.z_class = LPR_CLASS;
    notice.z_class_inst = LPR_INSTANCE;
    notice.z_opcode = "";
    snprintf (mysender, sizeof (mysender), "LPR-DAEMON@%s", ZGetRealm());
    notice.z_sender = mysender;
    notice.z_default_format = "From LPR-DAEMON $1:\n$2";
    
    notice.z_recipient = rcpt ;
    if (*rcpt == '\0')
	return 0;

    if ((retval = ZSendList(&notice, lines, sizeof(lines)/sizeof(*lines), ZNOAUTH)) != ZERR_NONE) {
	syslog (LOG_NOTICE, "zLPRng: error while sending notice: %s", error_message(retval)) ;
	closelog() ;
	exit(0);
    } 
    
    closelog() ;
    return 0 ;
}
