/* WARNING: hack. Should be rewritten using zwrite.c --Derrick */
/*
 * zrepeat:  Replay previous Zephyr messages
 *
 * Created: Jay Laefer, October 28, 1991.
 *
 */
/***********************************************************
        Copyright 1991 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/

#include <sysdep.h>

/* There is no support in here for the ZEPHYRDIR environment variable. */

#define MAX_REPEAT 128

main(argc, argv)
  int argc;
  char **argv;
{
    int count, ii, arg;
    char repeat[MAX_REPEAT + 1];
    char *user = NULL;

    if (argc == 0) {
	fprintf(stderr, "Usage: zrepeat [-s user] [n]\n");
	exit(1);
    }

    arg = 1;
    count = 0;
    
    for (;arg<argc;arg++) {
      if (*argv[arg] != '-') {
	count = atoi(argv[arg]);
	break;
      } 
      switch (argv[arg][1]) {
      case 's':
	user = argv[arg];
	break;
      default:
	fprintf(stderr, "Usage: zrepeat [-s user] [n]\n");
      }
    }
    
    if (count == 0)
      count = 1;

    if (count < 1 || count > MAX_REPEAT) {
	fprintf(stderr, "Value of n must be between 1 and %d.\n", MAX_REPEAT);
	exit(1);
    }

    /* create the message string */
    for (ii = 0; ii < count; ii++) repeat[ii] = 'x';
    repeat[ii] = '\0';

    if (!user)
      if ((user = getenv("USER")) == NULL) {
	fprintf(stderr, "zrepeat: USER environment variable not set\n");
	exit(1);
      }

    if (strncasecmp((argv[0]+strlen(argv[0])-8), "zprepeat", 8) == 0)
      execlp("zwrite", "zwrite", user, "-O", "PREPLAY", "-m", repeat, 
	     (char *)0);
    else
      execlp("zwrite", "zwrite", user, "-O", "REPLAY", "-m", repeat, 
	     (char *)0);
    perror("zrepeat");
    return 1;
}
