#ifndef x_driver_MODULE
#define x_driver_MODULE

/* This file is part of the Project Athena Zephyr Notification System.
 * It is one of the source files comprising zwgc, the Zephyr WindowGram
 * client.
 *
 *      Created by:     Marc Horowitz <marc@athena.mit.edu>
 *
 *      $Id: X_driver.h,v 1.4 2000/02/04 00:58:19 assar Exp $
 *
 *      Copyright (c) 1989 by the Massachusetts Institute of Technology.
 *      For copying and distribution information, see the file
 *      "mit-copyright.h".
 */


#include <zephyr/mit-copyright.h>

#include <X11/Xlib.h>

#include "new_string.h"

extern Display *dpy;

extern char *get_string_resource(string name, string class);
extern int get_bool_resource(string name, string class, int default_value);
extern unsigned long x_string_to_color (char *name, unsigned long def);
extern int open_display_and_load_resources(int *pargc, char **argv);
extern int X_driver_ioerror(Display *display);
extern int X_driver_init(char *drivername, char notfirst,
			 int *pargc, char **argv);
extern void X_driver_reset(void);
extern char *X_driver(string text);
#endif
