/* This file is part of the Project Athena Zephyr Notification System.
 * It is one of the source files comprising zwgc, the Zephyr WindowGram
 * client.
 *
 *      Created by:     Marc Horowitz <marc@athena.mit.edu>
 *
 *      $Id: xshow.h,v 1.6 2000/07/07 04:05:11 assar Exp $
 *
 *      Copyright (c) 1989 by the Massachusetts Institute of Technology.
 *      For copying and distribution information, see the file
 *      "mit-copyright.h".
 */


#include <zephyr/mit-copyright.h>

#ifndef _ZWGC_XSHOW_H_
#define _ZWGC_XSHOW_H_

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xresource.h>

#include "formatter.h"

typedef struct _xwin {
   unsigned long bgcolor;
   int xpos,ypos,xsize,ysize;
   int numblocks;
   xblock *blocks;
   char *text;
} xwin;

void xshowinit(void);
char *mode_to_colorname (Display *dpy, char *style, xmode *mode);
void fixup_and_draw(Display *dpy, char *style, xauxblock *auxblocks,
		    xblock *blocks, int num, xlinedesc *lines,
		    int numlines, int beepcount);
char *no_dots_downcase_var(char *str);
void xshow(Display *dpy, desctype *desc, int numstr, int numnl);
void x_get_input(void *v_dpy);

#endif /* _ZWGC_XSHOW_H_ */
