/*
 * $Id: add_to_error_table.c,v 1.1.1.1 2000/02/02 12:02:02 tol Exp $
 *
 * Copyright 1987 by the Student Information Processing Board
 * of the Massachusetts Institute of Technology
 *
 * For copyright info, see "mit-sipb-copyright.h".
 */

static const char rcsid[] = "$Id: add_to_error_table.c,v 1.1.1.1 2000/02/02 12:02:02 tol Exp $";

#include <stdio.h>
#include <string.h>
#include "error_table.h"
#include "mit-sipb-copyright.h"

/* This is for compatibility with the AFS com_err.  It does the
 * initialization which our version of com_err inlines into the code
 * generated by compile_et.  The name isn't very intuitive, but we
 * didn't make it up. */
void add_to_error_table(struct et_list *table)
{
    struct et_list *et;

    /* Don't add the same error table twice. */
    for (et = _et_list; et; et = et->next) {
	if (et->table == table->table)
	    return;
    }
    table->next = _et_list;
    _et_list = table;
}
