%{
#include "error_table.h"
#include "err_table.h"
char *dupstr(const char *string);
#undef yywrap
int num_lines = 0;
%}

PC	[^\"]
AN	[A-Z_a-z0-9]
%%
\n		++num_lines;

error_table	return ERROR_TABLE;
et		return ERROR_TABLE;
error_code	return ERROR_CODE_ENTRY;
ec		return ERROR_CODE_ENTRY;
end		return END;

[\t\n ]		;

\"{PC}*\"	{ register char *p; yylval.dynstr = dupstr(yytext+1);
		  p=strrchr(yylval.dynstr, '"');
		  if (p) *p='\0';
		  return QUOTED_STRING;
		}

{AN}*	{ yylval.dynstr = dupstr(yytext); return STRING; }

#.*\n		;

.		{ return (*yytext); }
%%
static const char l_rcsid[] = "$Id: et_lex.lex.l,v 1.3 2003/02/18 20:49:41 lha Exp $";

int yywrap()
{
	return 1;
}
