/* This file is part of the Project Athena Zephyr Notification System.
 * It contains the version identification of the Zephyr server
 *
 *	Created by:	John T. Kohl
 *
 *	Copyright (c) 1989 by the Massachusetts Institute of Technology.
 *	For copying and distribution information, see the file
 *	"mit-copyright.h". 
 */

#include <zephyr/mit-copyright.h>

#include "zserver.h"
#include <zephyr-version.h>

RCSID("$Id: version.c,v 1.7 2000/06/11 11:33:54 lha Exp $");

const char zephyr_version_l[] = "Zephyr system version 2.0";

#undef DEBUG_STR
#ifdef DEBUG
#define DEBUG_STR "(DEBUG)"
#else
#define DEBUG_STR ""
#endif

const char version[] = "Zephyr server " DEBUG_STR "$Revision: 1.7 $";

char *
get_version(void)
{
  static char vers_buf[256];

  if (vers_buf[0] == '\0') {
      snprintf (vers_buf, sizeof(vers_buf), "Zephyr Server %s %s %s",
		DEBUG_STR,
		zephyr_version_l,
		zephyr_long_version);
  }
  return(vers_buf);
}
