/* zmail copyright 1990 Jim Zelenka, even though it's a hack */

#include <config.h>
#include <sysdep.h>
#include <zephyr/zephyr.h>
#include <pwd.h>
#if defined (POSIX) || defined (HAVE_DIRENT_H) || defined (__GNU_LIBRARY__)
#include <dirent.h>
#else
#ifdef  HAVE_SYS_NDIR_H
#include <sys/ndir.h>
#endif  /* HAVE_SYS_NDIR_H */
#ifdef  HAVE_SYS_DIR_H
#include <sys/dir.h>
#endif  /* HAVE_SYS_DIR_H */
#ifdef HAVE_NDIR_H
#include <ndir.h>
#endif  /* HAVE_NDIR_H */
#endif

#define IDSIZE 7
#ifndef MAXPATHLEN
#define MAXPATHLEN 1024
#endif
#define HDSIZE 200

#ifdef __STDC__
int countfiles(char uid[IDSIZE], char homedir[HDSIZE]);
void donerun(void);
char *iword(int foo);
#else
int countfiles();
void donerun();
char *iword();
#endif

unsigned short port=0;

main(argc, argv)
int argc;
char **argv;
{
  int x=0, y=0, z, qq, debug=0, pid, seconds;
  char sleepsec[5], homedir[HDSIZE], message[1024];
  char uid[IDSIZE];
  unsigned char nn[8];
 
  strcpy (sleepsec, "40"); /* default number of seconds to sleep */

  for(qq=1; qq<argc; qq++) {
#ifdef DEBUG
    if (!strcmp(argv[qq], "-d"))
      debug=1;
#endif
    if (!strcmp(argv[qq], "-st")) {
      if ((qq+2)>argc) {
        fprintf(stderr, "You must specify a time with the -st option\n");
        exit(1); 
      }
      else
        strcpy(sleepsec, argv[qq+1]);
	}
  }
  if (!debug) { /* fork and let parent die if not debugging */
    int pgrp,npgrp;
  /* to try to get SIGHUP on user logout */
#if defined(HAVE_GETSID)
  setpgid(0, getsid(0));
#elif defined(HAVE_GETPGID)
  setpgid(0, getpgid(getppid()));
#elif !defined(GETPGRP_VOID)
  setpgid(0, getpgrp(getppid()));
#endif

    pid = fork();
    if (pid)
      exit(0);
  }  
  strcpy (uid, getpwuid(getuid())->pw_name); /* uid is current user id (ascii) */
  strcpy (homedir, getpwuid(getuid())->pw_dir); /* put full path to home directory in homedir */
#ifdef DEBUG
  if (debug) {
    printf("Opening %s/Mailbox for reading.\n", homedir);
    printf("Signing ID: %s\n", uid);
    printf("Sleeping for %s seconds.\n\n", sleepsec);
  }
#endif
  seconds = atoi(sleepsec);
  x = countfiles(uid, homedir);				    
  while (1) {				    
    y = countfiles(uid, homedir);
    if (y > x) {
		sprintf(message, "Attention: Incoming mail.\n%d new %s.\n%d total %s.", y-x, 
				iword(y-x), y-2, iword(y-2));
#ifdef DEBUG
		if (debug) printf("Sending: \"%s\"\n", message);
#endif
		zsend(uid, message, " ", "MESSAGE", "ZMAIL");
#ifdef DEBUG
		if (debug) printf("sent\n");
#endif
    }
    x = y;
#ifdef DEBUG
	if (debug) printf("Asleep.\n");
#endif
	sleep(seconds);
#ifdef DEBUG
	if (debug) printf("Awake.\n");
#endif
  }
}

char *iword(foo)
int foo;
{
	if (foo > 1)
		return("items");
	else
		return("item");
}

int countfiles(uid, homedir)
char uid[IDSIZE], homedir[HDSIZE];
{
  int x=0;
  char xname[100];
  DIR *xpq1;
  struct direct *dri;
  
  strcpy(xname, homedir);

  strcat(xname, "/Mailbox");
  xpq1 = opendir(xname);
  if (xpq1 == NULL) {
    printf("Failure peeking at %s\n", xname);
    exit(1);
  }
  for (dri = readdir(xpq1); dri != NULL; dri = readdir(xpq1))
    x++;
  closedir(xpq1);
  return(x);
}
